package org.maachang.dao ;

import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.RecordFactory;

/**
 * DaoSessionFactory.
 *
 * @version 2007/11/03
 * @author  masahito suzuki
 * @since MaachangDao 1.00
 */
public class DaoSessionFactory {
    
    /**
     * シングルトン.
     */
    private static final DaoSessionFactory SNGL = new DaoSessionFactory() ;
    
    /**
     * レコードファクトリ.
     */
    private RecordFactory recordFactory = null ;
    
    /**
     * コンストラクタ.
     */
    private DaoSessionFactory() {
    }
    
    /**
     * オブジェクトを取得.
     * <BR><BR>
     * オブジェクトを取得します.
     * <BR>
     * @return DaoSessionFactory オブジェクト情報が返されます.
     */
    public static final DaoSessionFactory getInstance() {
        return SNGL ;
    }
    
    /**
     * レコードファクトリを設定.
     * <BR><BR>
     * レコードファクトリを設定します.
     * <BR>
     * @param recordFactory 対象のレコードファクトリを設定します.
     */
    protected void setRecordFactory( RecordFactory recordFactory ) {
        this.recordFactory = recordFactory ;
    }
    
    /**
     * レコードファクトリを取得.
     * <BR><BR>
     * レコードファクトリを取得します.
     * <BR>
     * @return RecordFactory レコードファクトリが返されます.
     */
    public RecordFactory getRecordFactory() {
        return recordFactory ;
    }
    
    /**
     * 新しいDaoSessionを取得.
     * <BR><BR>
     * 新しいDaoSessionを取得します.
     * <BR>
     * @return DaoSession 新しいDaoSessionが返されます.
     * @exception MaachangDaoException MaachangDao例外.
     */
    public DaoSession getDaoSession()
        throws MaachangDaoException {
        if( recordFactory != null ) {
            Record record = null ;
            DaoSession ret = null ;
            try {
                record = recordFactory.getRecord() ;
                ret = new DaoSession( record ) ;
            } catch( Exception e ) {
                if( record != null ) {
                    try {
                        record.close() ;
                    } catch( Exception ee ) {
                    }
                }
                throw new MaachangDaoException( e ) ;
            }
            return ret ;
        }
        throw new MaachangDaoException(
            "初期化されていないか、条件が不正です" ) ;
    }
    
    /**
     * 新しいレコードを取得.
     * <BR><BR>
     * 新しいレコードを取得します.
     * <BR>
     * @return Record 新しいレコード情報が返されます.
     * @exception MaachangDaoException MaachangDao例外.
     */
    public Record getRecord()
        throws MaachangDaoException {
        if( recordFactory != null ) {
            Record ret = null ;
            try {
                ret = recordFactory.getRecord() ;
            } catch( Exception e ) {
                if( ret != null ) {
                    try {
                        ret.close() ;
                    } catch( Exception ee ) {
                    }
                }
                throw new MaachangDaoException( e ) ;
            }
            return ret ;
        }
        throw new MaachangDaoException(
            "初期化されていないか、条件が不正です" ) ;
    }
}
