﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/es/model/SnapshotOptions.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ElasticsearchService
{
namespace Model
{

SnapshotOptions::SnapshotOptions() : 
    m_automatedSnapshotStartHour(0),
    m_automatedSnapshotStartHourHasBeenSet(false)
{
}

SnapshotOptions::SnapshotOptions(const JsonValue& jsonValue) : 
    m_automatedSnapshotStartHour(0),
    m_automatedSnapshotStartHourHasBeenSet(false)
{
  *this = jsonValue;
}

SnapshotOptions& SnapshotOptions::operator =(const JsonValue& jsonValue)
{
  if(jsonValue.ValueExists("AutomatedSnapshotStartHour"))
  {
    m_automatedSnapshotStartHour = jsonValue.GetInteger("AutomatedSnapshotStartHour");

    m_automatedSnapshotStartHourHasBeenSet = true;
  }

  return *this;
}

JsonValue SnapshotOptions::Jsonize() const
{
  JsonValue payload;

  if(m_automatedSnapshotStartHourHasBeenSet)
  {
   payload.WithInteger("AutomatedSnapshotStartHour", m_automatedSnapshotStartHour);

  }

  return payload;
}

} // namespace Model
} // namespace ElasticsearchService
} // namespace Aws
