﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/iam/IAM_EXPORTS.h>
#include <aws/iam/IAMRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace IAM
{
namespace Model
{

  /**
   */
  class AWS_IAM_API UploadSigningCertificateRequest : public IAMRequest
  {
  public:
    UploadSigningCertificateRequest();
    Aws::String SerializePayload() const override;

  protected:
    void DumpBodyToUrl(Aws::Http::URI& uri ) const override;

  public:

    /**
     * <p>The name of the user the signing certificate is for.</p> <p>This parameter
     * allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
     * string of characters consisting of upper and lowercase alphanumeric characters
     * with no spaces. You can also include any of the following characters: =,.@-</p>
     */
    inline const Aws::String& GetUserName() const{ return m_userName; }

    /**
     * <p>The name of the user the signing certificate is for.</p> <p>This parameter
     * allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
     * string of characters consisting of upper and lowercase alphanumeric characters
     * with no spaces. You can also include any of the following characters: =,.@-</p>
     */
    inline void SetUserName(const Aws::String& value) { m_userNameHasBeenSet = true; m_userName = value; }

    /**
     * <p>The name of the user the signing certificate is for.</p> <p>This parameter
     * allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
     * string of characters consisting of upper and lowercase alphanumeric characters
     * with no spaces. You can also include any of the following characters: =,.@-</p>
     */
    inline void SetUserName(Aws::String&& value) { m_userNameHasBeenSet = true; m_userName = std::move(value); }

    /**
     * <p>The name of the user the signing certificate is for.</p> <p>This parameter
     * allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
     * string of characters consisting of upper and lowercase alphanumeric characters
     * with no spaces. You can also include any of the following characters: =,.@-</p>
     */
    inline void SetUserName(const char* value) { m_userNameHasBeenSet = true; m_userName.assign(value); }

    /**
     * <p>The name of the user the signing certificate is for.</p> <p>This parameter
     * allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
     * string of characters consisting of upper and lowercase alphanumeric characters
     * with no spaces. You can also include any of the following characters: =,.@-</p>
     */
    inline UploadSigningCertificateRequest& WithUserName(const Aws::String& value) { SetUserName(value); return *this;}

    /**
     * <p>The name of the user the signing certificate is for.</p> <p>This parameter
     * allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
     * string of characters consisting of upper and lowercase alphanumeric characters
     * with no spaces. You can also include any of the following characters: =,.@-</p>
     */
    inline UploadSigningCertificateRequest& WithUserName(Aws::String&& value) { SetUserName(std::move(value)); return *this;}

    /**
     * <p>The name of the user the signing certificate is for.</p> <p>This parameter
     * allows (per its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
     * string of characters consisting of upper and lowercase alphanumeric characters
     * with no spaces. You can also include any of the following characters: =,.@-</p>
     */
    inline UploadSigningCertificateRequest& WithUserName(const char* value) { SetUserName(value); return *this;}


    /**
     * <p>The contents of the signing certificate.</p> <p>The <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this
     * parameter is a string of characters consisting of any printable ASCII character
     * ranging from the space character (\u0020) through end of the ASCII character
     * range as well as the printable characters in the Basic Latin and Latin-1
     * Supplement character set (through \u00FF). It also includes the special
     * characters tab (\u0009), line feed (\u000A), and carriage return (\u000D).</p>
     */
    inline const Aws::String& GetCertificateBody() const{ return m_certificateBody; }

    /**
     * <p>The contents of the signing certificate.</p> <p>The <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this
     * parameter is a string of characters consisting of any printable ASCII character
     * ranging from the space character (\u0020) through end of the ASCII character
     * range as well as the printable characters in the Basic Latin and Latin-1
     * Supplement character set (through \u00FF). It also includes the special
     * characters tab (\u0009), line feed (\u000A), and carriage return (\u000D).</p>
     */
    inline void SetCertificateBody(const Aws::String& value) { m_certificateBodyHasBeenSet = true; m_certificateBody = value; }

    /**
     * <p>The contents of the signing certificate.</p> <p>The <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this
     * parameter is a string of characters consisting of any printable ASCII character
     * ranging from the space character (\u0020) through end of the ASCII character
     * range as well as the printable characters in the Basic Latin and Latin-1
     * Supplement character set (through \u00FF). It also includes the special
     * characters tab (\u0009), line feed (\u000A), and carriage return (\u000D).</p>
     */
    inline void SetCertificateBody(Aws::String&& value) { m_certificateBodyHasBeenSet = true; m_certificateBody = std::move(value); }

    /**
     * <p>The contents of the signing certificate.</p> <p>The <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this
     * parameter is a string of characters consisting of any printable ASCII character
     * ranging from the space character (\u0020) through end of the ASCII character
     * range as well as the printable characters in the Basic Latin and Latin-1
     * Supplement character set (through \u00FF). It also includes the special
     * characters tab (\u0009), line feed (\u000A), and carriage return (\u000D).</p>
     */
    inline void SetCertificateBody(const char* value) { m_certificateBodyHasBeenSet = true; m_certificateBody.assign(value); }

    /**
     * <p>The contents of the signing certificate.</p> <p>The <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this
     * parameter is a string of characters consisting of any printable ASCII character
     * ranging from the space character (\u0020) through end of the ASCII character
     * range as well as the printable characters in the Basic Latin and Latin-1
     * Supplement character set (through \u00FF). It also includes the special
     * characters tab (\u0009), line feed (\u000A), and carriage return (\u000D).</p>
     */
    inline UploadSigningCertificateRequest& WithCertificateBody(const Aws::String& value) { SetCertificateBody(value); return *this;}

    /**
     * <p>The contents of the signing certificate.</p> <p>The <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this
     * parameter is a string of characters consisting of any printable ASCII character
     * ranging from the space character (\u0020) through end of the ASCII character
     * range as well as the printable characters in the Basic Latin and Latin-1
     * Supplement character set (through \u00FF). It also includes the special
     * characters tab (\u0009), line feed (\u000A), and carriage return (\u000D).</p>
     */
    inline UploadSigningCertificateRequest& WithCertificateBody(Aws::String&& value) { SetCertificateBody(std::move(value)); return *this;}

    /**
     * <p>The contents of the signing certificate.</p> <p>The <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this
     * parameter is a string of characters consisting of any printable ASCII character
     * ranging from the space character (\u0020) through end of the ASCII character
     * range as well as the printable characters in the Basic Latin and Latin-1
     * Supplement character set (through \u00FF). It also includes the special
     * characters tab (\u0009), line feed (\u000A), and carriage return (\u000D).</p>
     */
    inline UploadSigningCertificateRequest& WithCertificateBody(const char* value) { SetCertificateBody(value); return *this;}

  private:

    Aws::String m_userName;
    bool m_userNameHasBeenSet;

    Aws::String m_certificateBody;
    bool m_certificateBodyHasBeenSet;
  };

} // namespace Model
} // namespace IAM
} // namespace Aws
