#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Editing operations on files -
# Copyright (C) 2013 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Remove lines exactly matching a string from a file =============
fileedit_rm_a_line ()
{
	local item dstpath tmpfile pattern
	item=$1
	dstpath=$2
	[ -n "$item" ] || return 0
	[ -e "$dstpath" ] || return 0
	tmpfile=$dstpath.fileedit_rm_a_line.tmp
	pattern=`str_escape_regexp "$item"`
	grep -v -E "^$pattern$" "$dstpath" 2> /dev/null > $tmpfile || :
	mv "$tmpfile" "$dstpath"
}

# ============= Add a line to a file if no matching one exists in the file =============
fileedit_add_a_line_if_new ()
{
	local item dstpath tmpfile pattern dstdir
	item=$1
	dstpath=$2
	[ -n "$item" ] || return 0
	[ -n "$dstpath" ] || return 0
	tmpfile=$dstpath.fileedit_add_a_line_if_new.tmp
	pattern=`str_escape_regexp "$item"`
	if [ -e "$dstpath" ]
	then
		cp "$dstpath" "$tmpfile"
		grep -q -E "^$pattern$" "$dstpath" \
			|| echo "$item" >> $tmpfile
	else
		dstdir=`dirname "$dstpath"`
		[ -d "$dstdir" ] || mkdir -p "$dstdir"
		echo "$item" > $tmpfile
	fi
	mv "$tmpfile" "$dstpath"
}

# ============= Remove lines exactly matching a string from multiple files =============
fileedit_rm_a_line_from_files ()
{
	local item
	item=$1
	[ -n "$item" ] || return 0
	while read filepath
	do
		fileedit_rm_a_line "$item" "$filepath"
	done
}

# ============= Add a line to each of multiple files if no matching one exists in the file =============
fileedit_add_a_line_to_files_if_new ()
{
	local item
	item=$1
	[ -n "$item" ] || return 0
	while read filepath
	do
		fileedit_add_a_line_if_new "$item" "$filepath"
	done
}

# ============= Add multiple lines to a file for what don't match any existing ones in the file =============
fileedit_add_lines_if_new ()
{
	local dstpath advance tmpfile tmpclip origin dstdir
	dstpath=$1
	advance=$2
	tmpfile=$dstpath.fileedit_add_lines_if_new.tmp
	tmpclip=${TMPDIR}/fileedit_add_lines_if_new:add
	if [ -e "$dstpath" ]
	then
		while read origin
		do
			grep -q -E "^`str_escape_regexp \"$origin\"`$" "$dstpath" \
				|| echo "$origin"
		done > $tmpclip
		if [ "@$advance" = @advance ]
		then
			cat "$tmpclip" "$dstpath"
		else
			cat "$dstpath" "$tmpclip"
		fi > $tmpfile
	else
		dstdir=`dirname "$dstpath"`
		[ -d "$dstdir" ] || mkdir -p "$dstdir"
		cat > $tmpfile
	fi
	mv "$tmpfile" "$dstpath"
}

# ============= Combine (possibly missing) lists into one =============
fileedit_combine_lists ()
{
	cat "$@" 2> /dev/null | sort -u || :
}

# ============= Manipulate old and new lines from an old and a new versions of a file =============
fileedit_manipulate_old_new_lines ()
{
	local oldsrc newsrc olddiff newdiff
	oldsrc=$1
	newsrc=$2
	olddiff=$3
	newdiff=$4
	tmpdiff=${TMPDIR}/fileedit_manipulate_old_new_lines::diff
	[ -e "$oldsrc" ] || oldsrc=/dev/null
	[ -e "$newsrc" ] || newsrc=/dev/null
	diff "$oldsrc" "$newsrc" > $tmpdiff && return 1
	grep '^<' "$tmpdiff" | sed 's/^< //' > $olddiff || :
	grep '^>' "$tmpdiff" | sed 's/^> //' > $newdiff || :
}

# ============= Manipulate old lines from an old and a new versions of a file =============
fileedit_manipulate_old_lines ()
{
	local oldsrc newsrc
	oldsrc=$1
	newsrc=$2
	tmpdiff=${TMPDIR}/fileedit_manipulate_old_lines::diff
	[ -e "$oldsrc" ] || oldsrc=/dev/null
	[ -e "$newsrc" ] || newsrc=/dev/null
	diff "$oldsrc" "$newsrc" > $tmpdiff && return 1
	grep '^<' "$tmpdiff" | sed 's/^< //'
}

# ============= Manipulate new lines from an old and a new versions of a file =============
fileedit_manipulate_new_lines ()
{
	local oldsrc newsrc
	oldsrc=$1
	newsrc=$2
	tmpdiff=${TMPDIR}/fileedit_manipulate_new_lines::diff
	[ -e "$oldsrc" ] || oldsrc=/dev/null
	[ -e "$newsrc" ] || newsrc=/dev/null
	diff "$oldsrc" "$newsrc" > $tmpdiff && return 1
	grep '^>' "$tmpdiff" | sed 's/^> //'
}

# ============= Check whether removed lines exists in updating from an old and a new versions of a file =============
fileedit_exists_old_lines ()
{
	local oldsrc newsrc
	oldsrc=$1
	newsrc=$2
	tmpdiff=${TMPDIR}/fileedit_exists_old_lines::diff
	[ -e "$oldsrc" ] || oldsrc=/dev/null
	[ -e "$newsrc" ] || newsrc=/dev/null
	diff "$oldsrc" "$newsrc" > $tmpdiff && return 1
	grep -q '^<' "$tmpdiff"
}
