#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libcommand.sh for portsreinstall-chroot-mount
# - Operations of commands as well as check of command line arguments -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Check and parse command line arguments =============
command_all_parse_args ()
{
	COMMAND_RESTART="$@"
	COMMAND_MODE=${1:-mount}
	shift || :
	case $COMMAND_MODE in
	mount | unmount )
		_command_parse_args__chk_no_arg $#
		;;
	*)
		message_echo "ERROR: Invalid command [$COMMAND_MODE]." >&2
		exit 1
		;;
	esac
	COMMAND_SHIFT=$(($num_args_init - $#))
}

# ============= Execute command operations which do not need package tools =============
command_all_exec_without_pkgtools ()
{
	case $COMMAND_MODE in
	mount )
		fs_mount
		exit
		;;
	unmount )
		fs_unmount
		exit
		;;
	esac
}
