#!/bin/sh -e
# ==============================================================================
# portsreinstall-chroot library script
# Overlay onto lib/libdatabase_maintain.sh for portsreinstall-chroot
# - Operations on the temporary database -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Destroy the builder chroot environment by preserving the option setting =============
database_maintain_destroy ()
{
	message_echo "Starting to clean up the builder chroot environment..."
	program_deregister_stage_complete CLEANUP_GUEST
	fs_destroy
	message_echo "Starting to reset the temporary database by preserving the option setting..."
	find "${DBDIR}" -depth 1 -maxdepth 1 \
		-not \( -name saved_options.sh \
			-or -name MYVERSION -or -name .lock \) \
		-exec rm -rf {} \; 2> /dev/null || :
	touch "${DBDIR}/MYVERSION"
}

# ============= Destroy the builder chroot environment and clean up the temporary database =============
database_maintain_clean ()
{
	message_echo "Starting to clean up the builder chroot environment..."
	fs_destroy
	message_echo "Starting to clean up the temporary database..."
	command_exec_without_pkgtools__notify_reset_options
	rm -rf "${DBDIR}"
}

# ============= Forcibly destroy the builder chroot environment and clean up the temporary database =============
database_maintain_clean_force ()
{
	[ -e "${DBDIR}/saved_options.sh" ] && . "${DBDIR}/saved_options.sh"
	database_maintain_clean
}
