#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libmain.sh
# - Common functions of main programs -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Set termination messages for special commands =============
main_set_termination_messages_special ()
{
	temp_terminate_process ()
	{
		local errno tmp_msg
		errno=${1:-0}
		tmp_msg=${TMPDIR}/temp_terminate_process:msg
		[ $errno -eq 0 -o $opt_batch_mode = yes ] && return
		temp_terminate_process_common "$errno"
		[ $opt_no_opening_message = yes -o -n "$COMMAND_RESTART" ] && return
		cat > $tmp_msg << eof
Instead, if you only want to construct the temporary database so as to stop before the actual reinstallation, execute as:
${APPNAME} prepare
eof
		message_cat "$tmp_msg"
	}
}
