#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/liboptions.sh
# - Command line options -
# Copyright (C) 2013-2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Database of options which are given at each run and not saved =============
# [Syntax of option databases]
# short_name, long_name, variable, defult_vaule, set_value
# Columns are delimited by tab characters.
options_db_onetime ()
{
	cat << eof
h	help	opt_help_mode	0	1
h	short-help	opt_help_mode	0	1
H	long-help	opt_help_mode	0	2
V	show-version	opt_show_version	no	yes
a	batch-mode	opt_batch_mode	no	yes
J	just-save-options	opt_just_save_options	no	yes
N	reset-targets	opt_reset_targets	no	yes
M	reset-minor-options	opt_reset_minor_options	no	yes
L	reload-conf	opt_reload_conf	no	yes
i	allow-new-targets	opt_allow_new_targets	no	yes
S	no-opening-message	opt_no_opening_message	no	yes
eof
}

# ============= Database of options which are saved and renewable at each run =============
options_db_saved_and_renewable ()
{
	cat << eof
C	apply-default-config	opt_apply_default_config	no	yes
A	non-interactive-ports-only	opt_batch_ports_only	no	yes
I	interactive-ports-only	opt_interactive_ports_only	no	yes
s	avoid-vulnerability-check	opt_avoid_vulner	no	yes
q	skip-unchanged-ports	opt_skip_unchanged	no	yes
b	include-buildtime-dependencies	opt_include_buildtime_dependencies	no	yes
B	exclude-runtime-dependencies	opt_include_runtime_dependencies	yes	no
d	keep-distfiles	opt_keep_distfiles	no	yes
k	suppress-self-upadte	opt_suppress_self_upadte	no	yes
g	suppress-pkgtools-upadte	opt_suppress_pkgtools_upadte	no	yes
c	suppress-clean-obsolete-database	opt_suppress_obsolete_db_clean	no	yes
D	suppress-entire-inspection-distinfo	opt_inspect_entire_distinfo	yes	no
n	dry-run	opt_dry_run	no	yes
X	deselect-all	opt_dialog_auto	no	none
Y	select-all	opt_dialog_auto	no	all
G	use-prebuilt-package	opt_inst_by_pkg_if_can	no	yes
l	use-legacy-package-for-missing-pkgng	opt_use_legacy_pkg_for_missing_pkgng	no	yes
f	disallow-force-continuation-for-looped-dependency	opt_disallow_force_continuation_for_looped_dependency	no	yes
j	delete-then-reinstall	opt_delete_then_reinstall	no	yes
F	fetch-only	opt_fetch_only	no	yes
x	no-exec-inst-script	opt_no_exec_inst_script	no	yes
eof
}

# ============= Database of options which are saved and renewable only at the initial runs of redo command (on target specification) =============
options_db_saved_and_renewable_in_redo_on_target ()
{
	cat << eof
t	target-and-dependents	opt_target_dependents	''	:
T	target-and-requirements	opt_target_requirements	''	:
O	target-only-itself	opt_target_itself	''	:
o	only-target-scope	opt_only_target_scope	no	yes
eof
}

# ============= Database of options which are saved and renewable only at the initial runs of redo command (on configuration files) =============
options_db_saved_and_renewable_in_redo_on_conf ()
{
	cat << eof
p	load-pkgtoolsconf-as-default	opt_load_pkgtoolsconf	undef	default
P	load-pkgtoolsconf-as-override	opt_load_pkgtoolsconf	undef	override
Q	ignore-pkgtoolsconf	opt_load_pkgtoolsconf	undef	no
eof
}
