#!/bin/sh -e
# ==============================================================================
# portsreinstall-chroot library script
# Overlay onto lib/libfs.sh for portsreinstall-chroot-mount
# - File system operations -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Terminate when the file systems for the builder chroot environment cannot be mounted: For mounting at the grand host =============
fs_terminate_if_mount_unavailable__mount_at_host ()
{
	if [ $opt_forcible_operation = no ]
	then
		temp_terminate_process ()
		{
			message_echo "ERROR: Cannot mount because the current file systems are being mounted from inside the virtual (chroot or jail) environment."  >&2
			message_echo "INFO: Instead of this command, mount from inside the virtual (chroot or jail) environment."
			message_echo "INFO: If the previous run of portsreinstall-chroot(8) was terminated accidentally, retry with -f option."
		}
		[ $TEMP_IN_TRAP = no ] || temp_terminate_process
		exit 1
	fi
	message_echo "WARNING: Forcibly operating file systems which should be mounted from inside the virtual (chroot or jail) environment."  >&2
}
