#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libmain.sh for portsreinstall-chroot-mount
# - Common functions of main programs -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Save the previous configuration if exists =============
main_save_prev_conf ()
{
}

# ============= Load the saved configuration =============
main_load_conf ()
{
	. "${DBDIR}/saved_options.sh"
	. "${DBDIR}/conf/setenv.sh"
}

# ============= Get complete configuration variable definitions by importing pkgtools.conf(5) if available =============
main_get_complete_conf ()
{
}

# ============= Parse the configuration =============
main_parse_conf ()
{
}

# ============= Check of the mounting/unmounting privilege of the environment =============
main_check_of_mounting_unmounting_privilege ()
{
	if ! fs_chk_mount_privilege || ! fs_chk_unmount_privilege
	then
		temp_terminate_process () { :; }
		message_echo "ERROR: The current environment does not have the full privilege to mount and unmount file systems." >&2
		exit 1
	fi
}
