#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libtemp.sh for portsreinstall-chroot-mount
# - Temporary directory and signal trapping -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Set the termination process =============
temp_setup_terminate_process ()
{
	temp_terminate_process ()
	{
		local errno
		errno=${1:-0}
		[ $opt_batch_mode = yes -o $errno -eq 0 ] && return
		message_echo
		if [ $errno -eq 130 ]
		then
			message_echo "INFO: Terminated at `message_timestamp`."
			message_echo
			message_echo " You can safely rerun to continue."
		else
			message_echo "INFO: Aborted at `message_timestamp`."
			message_echo
			message_echo " You may rerun to continue after manually resolving the problem."
		fi
	}
}
