#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libusage.sh for portsreinstall-chroot-mount
# - Help messages -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Content of the short help =============
usage_short_content ()
{
	cat << eof
USAGE: ${APPNAME} [OPTIONS] [--] [command]

[OPTIONS]
 <Group 1: Just show messages and exit without operation>
 -H : Show a long help whose content is the same as the manual page.
 -h : Show this short help.
 -V : Show the current version.
 <Group 2: Effective anytime>
 -a : Suppress messages to be batch-friendly.
 -f: Forcible operation to ignore the lock.
 -J : Exit by doing nothing but just saving the options and command mode
 -S : Suppress the credit, opening and terminating messages.

[ARGUMENTS]
 command:
            mount (default)  | unmount

[DESCRIPTIONS]
 This utility is for assisting portsreinstall-chroot(8) to mount and unmount a builder environment at the grand host environment in case that the target environment is a chroot(8) or jail(8) virtual environment which does not have sufficient privilege to operate the file systems. Execution of this utility will be suggested by portsreinstall-chroot(8) executed at the target environment. The executable file of this utility is installed outside the scope of the search paths, and expected to be launched by specifying the full path.


[ROBUSTNESS AGAINST TERMINATION AND RESTART]
 Execution of this utility can be terminated at any points and restarted from there.
eof
}
