#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libcommand.sh for portsreinstall-chroot
# - Operations of commands as well as check of command line arguments -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Check the necessity of opening notice =============
command_all_chk_need_opening_notice ()
{
	false
}

# ============= Execute command operations before getting the temporary database ready =============
command_all_exec_before_db_creation ()
{
	local COMMAND_RESTART COMMAND_MODE COMMAND_OPERATION
	COMMAND_RESTART="$@"
	COMMAND_MODE=${1:-do}
	shift || :
	case $COMMAND_MODE in
	clean )
		COMMAND_OPERATION=${1:-normal}
		shift || :
		_command_parse_args__chk_no_arg $#
		case $COMMAND_OPERATION in
		force )
			database_maintain_clean_force
			exit
			;;
		esac
		;;
	esac
}

# ============= Check and parse command line arguments =============
command_all_parse_args ()
{
	local num_args_init
	num_args_init=$#
	COMMAND_RESTART="$@"
	COMMAND_MODE=${1:-do}
	shift || :
	case $COMMAND_MODE in
	clean )
		COMMAND_OPERATION=${1:-normal}
		shift || :
		case $COMMAND_OPERATION in
		normal )
			misc_chk_privilege
			;;
		esac
		_command_parse_args__chk_no_arg $#
		;;
	auto )
		COMMAND_RESTART=$COMMAND_MODE
		misc_chk_privilege
		;;
	enter )
		fs_inspect_fs_privilege
		if ! fs_chk_mount > /dev/null && ! ( misc_chk_privilege )
		then
			message_echo "ERROR: The file system of the builder chroot environment is not yet ready." >&2
			exit 1
		fi
		_command_parse_args__chk_no_arg $#
		;;
	mount )
		fs_inspect_fs_privilege
		if fs_chk_mount > /dev/null
		then
			message_echo "INFO: Already mounted"
			exit
		fi
		misc_chk_privilege
		_command_parse_args__chk_no_arg $#
		;;
	unmount )
		fs_inspect_fs_privilege
		if fs_chk_unmount > /dev/null
		then
			message_echo "INFO: Already unmounted"
			exit
		fi
		misc_chk_privilege
		_command_parse_args__chk_no_arg $#
		;;
	do | sync | destroy )
		misc_chk_privilege
		_command_parse_args__chk_no_arg $#
		;;
	options )
		_command_parse_args__chk_no_arg $#
		;;
	*)
		message_echo "ERROR: Invalid command [$COMMAND_MODE]." >&2
		exit 1
		;;
	esac
	COMMAND_SHIFT=$(($num_args_init - $#))
}

# ============= Execute command operations which should be done without upgrade of tools =============
command_all_exec_before_tools_upgrade ()
{
	case $COMMAND_MODE in
	clean )
		database_maintain_clean
		[ $opt_no_opening_message = yes ] || message_echo "Done"
		exit
		;;
	destroy )
		database_maintain_destroy
		[ $opt_no_opening_message = yes ] || message_echo "Done"
		exit
		;;
	unmount )
		fs_unmount
		exit
		;;
	mount )
		command_do_chroot_cleanup
		fs_build_chroot
		fs_mount
		temp_reset_termination_messages_common
		[ $opt_no_opening_message = yes ] || message_echo "Done"
		exit
		;;
	enter )
		if misc_chk_privilege
		then
			command_do_chroot_cleanup
			fs_build_chroot
			fs_mount
		elif ! fs_chk_mount > /dev/null
		then
			message_echo "ERROR: The file system of the builder chroot environment is not ready." >&2
			exit 1
		fi
		command_do_chroot_enter_shell
		if misc_chk_privilege
		then
			message_echo "Exited successfully"
			program_deregister_stage_complete UPGRADE_GUEST
		fi
		exit
		;;
	sync )
		command_do_chroot_cleanup
		fs_build_chroot
		fs_mount
		command_do_update_host_files
		[ $opt_no_opening_message = yes ] || message_echo "Done"
		exit
		;;
	esac
}

# ============= Execute command operations as the main process =============
command_all_exec_main ()
{
	case $COMMAND_MODE in
	do | auto )
		command_do_chroot_cleanup
		command_do_starter_portsnap
		command_do_starter_pkg
		command_do_pre
		command_do_starter_clean
		command_do_main_init_resinst
		command_do_chroot_enter_if_incomplete "$@"
		command_do_post
		command_do_ending_process
		;;
	esac
}
