#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libusage.sh for portsreinstall-chroot
# - Help messages -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Content of the short help =============
usage_short_content ()
{
	cat << eof
USAGE: portsreinstall-chroot [OPTIONS] [--] [command]

[OPTIONS]
 <Group 1: Just show messages and exit without operation>
 -H : Show a long help whose content is the same as the manual page.
 -h : Show this short help.
 -V : Show the current version.
 <Group 2: Effective anytime>
 -a : Suppress messages to be batch-friendly.
 -E delimiter(s) : Custom delimiter character(s) for -e option.
 -J : Exit by doing nothing but just saving the options and command mode
 -S : Suppress the credit, opening and terminating messages.
 <Group 3: Saved and not renewable until cleaning>
 -b : Base directory of the chroot environment (default: /home/.portsreinstall-chroot).
 -c : Suppress cleaning the temporary database even if its obsolete.
 -d : Forcibly invalidate the privilege of mounting/unmounting file systems.
 -e dir[,dir2[,...]] : Extra directories to mount for the chroot environment.
 -f : Full course mode.
 -g : Adjust all operations as post-processes after system upgrade.
 -P : Import settings from pkgtools.conf(5) as the secondary if exists.
 -p : Import settings from pkgtools.conf(5) as the primary if exists (default).
 -Q : Ignore pkgtools.conf(5) even if it exists.
 -s : Share the ports tree and package database with the host by nullfs

[ARGUMENTS]
 command:
            do (default) | auto [options] [arguments]
          | enter
          | mount | unmount
          | sync
          | destroy
          | clean [normal] | clean force
          | options
 
[DESCRIPTIONS]
 This utility assists to update packages by creating and using chroot environment for building. The chroot environment is first created by forking the host environment, and the user is asked to complete update of packages at the chroot environment.

[ROBUSTNESS AGAINST TERMINATION AND RESTART]
 Execution of the commands except "clean" and "options" commands can be terminated at any points and restarted from there with the same options saved in the temporary database (independent among utilities). The saved options can be changed by the ways depending on the assigned groups of the options. The options and execution progress are reset to the default by "clean" command.
eof
}
