#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Interface of libraries for operations of commands as well as check of command line arguments -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Variables =============
COMMAND_MODE=do
COMMAND_SHIFT=0
COMMAND_OPERATION=
COMMAND_SAVE_DIR=
COMMAND_LOAD_FILE=
COMMAND_SHOW_SUBJECT=
COMMAND_DO_MODE=all
COMMAND_RESTART=
COMMAND_SHOW_OPTIONS=
COMMAND_SHOW_DEPTAG=
COMMAND_SHOW_LEVEL=
COMMAND_SHOW_KEYWORD=

# ============= Check the necessity of opening notice =============
command_all_chk_need_opening_notice ()
{
	:
}

# ============= Check the number of following command line arguments (in case glob arguments are needed) =============
_command_parse_args__chk_glob_args ()
{
	local nargs
	nargs=$1
	[ $nargs -gt 0 ] && return
	message_echo "ERROR: No port glob is specified." >&2
	exit 1
}

# ============= Check the number of following command line arguments (in case without arguments) =============
_command_parse_args__chk_no_arg ()
{
	local nargs term_redundant_argument
	nargs=$1
	[ $nargs -eq 0 ] && return
	term_redundant_argument='A redundant argument is'
	[ $nargs -gt 1 ] && term_redundant_argument='Redundant arguments are'
	message_echo "ERROR: $term_redundant_argument specified." >&2
	exit 1
}

# ============= Execute command operations before getting the temporary database ready =============
command_all_exec_before_db_creation ()
{
}

# ============= Check and parse command line arguments =============
command_all_parse_args ()
{
}

# ============= Notify that option settings are reset =============
command_exec_without_pkgtools__notify_reset_options ()
{
	[ $opt_no_opening_message = yes ] && return
	message_echo "NOTE: Option settings are ignored (because of no effect) and reset."
}

# ============= Execute command operations which do not need package tools =============
command_all_exec_without_pkgtools ()
{
}


# ============= Notify that option settings are ignored because of no effect =============
_command_exec_irrespective_of_saved_options__notify_ignored_options ()
{
	[ $opt_no_opening_message = yes ] && return
	message_echo "NOTE: Option settings are ignored because they have no effect on this command."
}

# ============= Execute command operations which are irrespective of option settings =============
command_all_exec_irrespective_of_saved_options ()
{
}

# ============= Execute command operations which should be carried out just after completing the option settings =============
command_all_exec_just_after_option_settings ()
{
	shift || :
	case $COMMAND_MODE in
	options )
		options_show_all
		exit
		;;
	esac
}

# ============= Execute command operations which should be done without upgrade of tools =============
command_all_exec_before_tools_upgrade ()
{
}

# ============= Execute command operations which must be done before the database construction =============
command_all_exec_command_specific_preconfiguration ()
{
}

# ============= Execute command operations of database construction =============
command_all_exec_build_database ()
{
}

# ============= Execute command operations which must be done before the main process =============
command_all_exec_before_main ()
{
}

# ============= Execute command operations as the main process =============
command_all_exec_main ()
{
}
