#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - "show" command operation -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Execute command operations which should be done without upgrade of tools =============
command_show ()
{
	local flag_filter_skip_unchanged flag_filter_only_target listdb pkgnamedb dbsuffix list origin_target
	flag_filter_skip_unchanged=
	flag_filter_only_target=
	pkgnamedb='moved_from obsolete initial'
	[ -n "$COMMAND_SHOW_DEPTAG" ] || COMMAND_SHOW_DEPTAG=`options_get_dependency_type`
	[ -n "$COMMAND_SHOW_LEVEL" ] || COMMAND_SHOW_LEVEL=`options_get_dependency_level`
	dbsuffix=$COMMAND_SHOW_DEPTAG.$COMMAND_SHOW_LEVEL
	case $COMMAND_SHOW_SUBJECT in
	todo | done | redo | resolved | inst_by_pkg | inst_built_default | inst_built_custom | failure | taboo | freeze | need | noneed | deleted | restored | fossil |conflict | moved )
		database_query_show_single_list_exec "$COMMAND_SHOW_SUBJECT" \
			"$COMMAND_SHOW_DEPTAG" "$COMMAND_SHOW_LEVEL" || :
		;;
	leaves | obsolete )
		database_query_show_single_list_exec "$COMMAND_SHOW_SUBJECT" \
			"$COMMAND_SHOW_KEYWORD" '' || :
		;;
	build_conflict_pkgs | inst_conflict_pkgs )
		case $COMMAND_SHOW_SUBJECT in
		build_conflict_pkgs )
			message_echo "Installed conflicting packages in the build:"
			mode=build
			;;
		inst_conflict_pkgs )
			message_echo "Installed conflicting packages in the installation:"
			mode=install
			;;
		esac
		pkgsys_eval_ports_glob "$@" | while read origin
		do
			pkgsys_get_conflicting_installed_pkgs "$mode" "$origin"
		done | sort -u
		;;
	initrequirements )
		grandtitle="Dependencies based on the initially installed packages"
		title="The following port(s) was/were required by %s:"
		list=requirements.$dbsuffix
		listdb='initial'
		pkgnamedb='initial'
		;;
	requirements )
		grandtitle="Dependencies based on the latest ports tree"
		title="The following port(s) is/are required by %s:"
		list=requirements.$dbsuffix
		listdb='requires'
		pkgnamedb='moved_from'
		;;
	initdependents )
		grandtitle="Dependencies based on the initially installed packages"
		title="The following port(s) depended on %s:"
		list=dependents.$dbsuffix
		listdb='initial'
		pkgnamedb='initial'
		;;
	dependents )
		grandtitle="Dependencies based on the latest ports tree"
		title="The following port(s) depend(s) on %s:"
		list=dependents.$dbsuffix
		listdb='requires'
		pkgnamedb='moved_from'
		;;
	conflict_files )
		grandtitle="Possible additional conflict files"
		title="The following packages' files conflict with %s:"
		list=possible_additional_conflict.csv
		listdb='requires'
		pkgnamedb='moved_from'
		database_query_show_two_column_lists "$grandtitle" "$title" "$list" "$listdb" "$pkgnamedb" "$@"
		;;
	status )
		grandtitle="Success/failure status in (re)installation"
		lists='todo|done|redo|resolved|inst_by_pkg|inst_built_default|inst_built_custom|failure|taboo|freeze|need|noneed|deleted|restored|fossil|conflict'
		database_query_show_list_inclusion_of_matching_port "$grandtitle" "$lists" "$pkgnamedb" \
			"$COMMAND_SHOW_DEPTAG" "$COMMAND_SHOW_LEVEL" "$@"
		;;
	errormessage )
		grandtitle="Error messages in (re)installation:"
		title="\n==== %s ===="
		list=error.log
		listdb='requires'
		pkgnamedb='moved_from'
		database_query_show_log "$grandtitle" "$title" "$list" "$listdb" "$pkgnamedb" "$@"
		;;
	esac
	case $COMMAND_SHOW_SUBJECT in
	initrequirements | requirements | initdependents | dependents )
		[ $COMMAND_SHOW_DEPTAG = none ] && \
			message_echo "WARNING: This command has no meaning with the current options setting." >&2
		database_query_show_port_lists "$grandtitle" "$title" "$list" "$listdb" "$pkgnamedb" "$COMMAND_SHOW_DEPTAG" "$COMMAND_SHOW_LEVEL" "$@"
		;;
	esac
}
