#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Operations for recording operation results to the temporary database -
# Copyright (C) 2013-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Update records by reflecting a successful result of (re/de)installation of a port =============
database_record_success ()
{
	local origin nodedir dbdir_esc tag level dbsuffix
	origin=$1
	nodedir=${DBDIR}/requires/$origin
	fileedit_add_a_line_if_new "$origin" "${DBDIR}/new_success_in_current_run"
	dbdir_esc=`str_escape_replaceval "${DBDIR}/requires/"`
	for tag in all run build none
	do
		for level in full direct
		do
			dbsuffix=$tag.$level
			if [ -e "$nodedir/dependents.$dbsuffix" ]
			then
				sed "s/^/$dbdir_esc/;s|$|/failed_requirements.$dbsuffix|" "$nodedir/dependents.$dbsuffix" | \
					fileedit_rm_a_line_from_files "$origin"
			fi
			if [ $level = full -a -e "$nodedir/ignored_dependents.$tag" ]
			then
				sed "s/^/$dbdir_esc/;s|$|/failed_requirements.$dbsuffix|" "$nodedir/ignored_dependents.$tag" | \
					fileedit_rm_a_line_from_files "$origin"
			fi
			if [ ! -e "$nodedir/installed_by_pkg" ] && \
				{
					cat "$nodedir/requirements.$dbsuffix" 2> /dev/null
					[ $level = full ] && cat "$nodedir/ignored_requirements.$tag" 2> /dev/null
				} | env LANG=C grep -q -Fx -f "${DBDIR}/failed.list" 2> /dev/null
			then
				fileedit_rm_a_line "$origin" "${DBDIR}/success.$dbsuffix.list"
				fileedit_add_a_line_if_new "$origin" "${DBDIR}/todo_after_requirements_succeed.$dbsuffix.list"
			else
				fileedit_add_a_line_if_new "$origin" "${DBDIR}/success.$dbsuffix.list"
				fileedit_rm_a_line "$origin" "${DBDIR}/todo_after_requirements_succeed.$dbsuffix.list"
				[ ! -e "$nodedir/necessary_upgrade.$dbsuffix" ] \
					|| mv "$nodedir/necessary_upgrade.$dbsuffix" "$nodedir/necessary_upgrade_completed.$dbsuffix"
			fi
		done
	done
	fileedit_rm_a_line "$origin" "${DBDIR}/failed.list"
	fileedit_rm_a_line "$origin" "${DBDIR}/damaged_package"
	touch "$nodedir/succeeded_once"
	rm -f "${DBDIR}/notes/$origin/note_failtre" "$nodedir/conf_updated"
}

# ============= Update records by reflecting a failed result of (re/de)installation of a port =============
database_record_failure ()
{
	local origin clean nodedir dbdir_esc tag level dbsuffix
	origin=$1
	clean=$2
	nodedir=${DBDIR}/requires/$origin
	fileedit_add_a_line_if_new "$origin" "${DBDIR}/failed.list"
	dbdir_esc=`str_escape_replaceval "${DBDIR}/requires/"`
	for tag in all run build none
	do
		for level in full direct
		do
			dbsuffix=$tag.$level
			fileedit_rm_a_line "$origin" "${DBDIR}/success.$dbsuffix.list"
			fileedit_rm_a_line "$origin" "${DBDIR}/todo_after_requirements_succeed.$dbsuffix.list"
			if [ -e "$nodedir/dependents.$dbsuffix" ]
			then
				sed "s/^/$dbdir_esc/;s|$|/failed_requirements.$dbsuffix|" "$nodedir/dependents.$dbsuffix" | \
					fileedit_add_a_line_to_files_if_new "$origin"
			fi
			if [ $level = full -a -e "$nodedir/ignored_dependents.$tag" ]
			then
				sed "s/^/$dbdir_esc/;s|$|/failed_requirements.$dbsuffix|" "$nodedir/ignored_dependents.$tag" | \
					fileedit_add_a_line_to_files_if_new "$origin"
			fi
		done
	done
	rm -f "$nodedir/succeeded_once"
	fileedit_rm_a_line "$origin" "${DBDIR}/inst_by_port_with_custom_conf.list"
	fileedit_rm_a_line "$origin" "${DBDIR}/inst_by_port_with_default_conf.list"
	fileedit_rm_a_line "$origin" "${DBDIR}/installation_complete_by_pkg.list"
	if [ -z "$clean" -o "@$clean" = @clean ]
	then
		message_echo "*** Trying to clean the failed build... (Ignore failures)"
		database_build_make "$origin" clean | message_cat
	fi
	message_echo "*** Skipping this port and proceeding to next forcibly..."
	message_echo
}

# ============= Record a port that it was damaged by losing or destroying installed files =============
database_record_reconf_recover_sanity ()
{
	local origin tag level dbsuffix
	origin=$1
	fileedit_add_a_line_if_new "$origin" "${DBDIR}/damaged_package"
	for tag in all run build none
	do
		for level in full direct
		do
			dbsuffix=$tag.$level
			fileedit_rm_a_line "$origin" "${DBDIR}/success.$dbsuffix.list"
			fileedit_rm_a_line "$origin" "${DBDIR}/todo_after_requirements_succeed.$dbsuffix.list"
		done
	done
	rm -f "${DBDIR}/requires/$origin/succeeded_once"
}
