#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Temporary directory and signal trapping -
# Copyright (C) 2013-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Variables =============
TMPDIR=/tmp	# Temporary directory
TEMP_IN_TRAP=no	# Whether to be in a error trap process

# ============= Default additional operation in a trap process =============
temp_terminate_process () { :; }

# ============= Warn when the temporary database is obsolete =============
temp_warn_obsolete_temp_db () { :; }

# ============= Creation of temporary work directories: Trap operation =============
temp_trap_init__opetration ()
{
	local errno
	errno=$1
	set +x
	TEMP_IN_TRAP=yes
	temp_warn_obsolete_temp_db >&2 || :
	temp_warn_obsolete_temp_db () { :; }
	temp_terminate_process $errno >&2 || :
	temp_terminate_process () { :; }
	rm -rf "${TMPDIR}" 2> /dev/null
	[ -n "${DBDIR}" -a x`cat "${DBDIR}/.lock" 2> /dev/null` = x$$ ] && rm -f "${DBDIR}/.lock"
	[ $errno -gt 0 -a $errno -ne 130 -a $opt_batch_mode = no -a $opt_no_opening_message = no ] && echo "(Exit code: $errno)" >&2
	exit $errno
}

# ============= Creation of temporary work directories =============
temp_trap_init ()
{
	trap 'temp_trap_init__opetration $?' 0 1 2 3 9 15 17 18
	{ until TMPDIR=`mktemp -dq /tmp/"${APPNAME}".XXXXXXXX` ; do : ; done ; }
	chgrp "`id -gn`" "${TMPDIR}"
}

# ============= Set the signal trap to be friendly for invoking a new version: Trap operation =============
temp_trap_for_invoking_new_version__opetration ()
{
	local errno
	errno=$1
	set +x
	rm -rf "${TMPDIR}" 2> /dev/null
	[ $errno -gt 0 -a $errno -ne 130 -a $opt_batch_mode = no -a $opt_no_opening_message = no ] && echo "(Exit code: $errno)" >&2
	exit $errno
}

# ============= Set the signal trap to be friendly for invoking a new version =============
temp_trap_for_invoking_new_version ()
{
	[ x`cat "${DBDIR}/.lock" 2> /dev/null` = x$$ ] && rm -f "${DBDIR}/.lock"
	trap 'temp_trap_for_invoking_new_version__opetration $?' 0 1 2 3 9 15 17 18
}

# ============= Set the message telling the current stage =============
temp_set_msg_current_stage ()
{
	echo "$*" > ${TMPDIR}/TEMP::MSG_CURRENT_STAGE
}

# ============= Get the message telling the current stage =============
temp_get_msg_current_stage ()
{
	cat "${TMPDIR}/TEMP::MSG_CURRENT_STAGE" 2> /dev/null || :
}

# ============= Reset the termination messages to the common one =============
temp_reset_termination_messages_common ()
{
	temp_terminate_process ()
	{
		local errno
		errno=${1:-0}
		temp_terminate_process_common "$errno"
	}
}
