#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Help messages -
# Copyright (C) 2013-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Content of the short help =============
usage_short_content ()
{
	cat << eof
USAGE: portsreinstall [OPTIONS] [--] [command]

[OPTIONS]
 <Group 1: Just show messages and exit without operation>
 -H : Show a long help whose content is the same as the manual page.
 -h : Show this short help.
 -V : Show the current version.
 <Group 2: Effective anytime>
 -a : Suppress messages to be batch-friendly.
 -i : Include new targets to the "needed" list.
 -J : Exit by doing nothing but just saving the options and command mode
 -M : Reset group 4 option settings.
 -S : Suppress the credit, opening and terminating messages.
 <Group 3: Effective only with redo command>
 -L : Reload configuration files and reset group 6 option settings.
 -N : Reset group 5 option settings.
 <Group 4: Saved and transferred to restarted runs, renewable by -M option>
 -A : Only non-interactive ports are (re)installed.
 -B : Exclude run-time dependencies in evaluation of dependencies.
 -b : Include build-time dependencies in evaluation of dependencies.
 -C : Skip "make config" by applying default port options if unconfigured.
 -c : Suppress cleaning the temporary database even if its obsolete.
 -D : Suppress entire inspection of distinfo in the ports tree.
 -d : Do not clean up obsolete or unused distfiles.
 -F: Fetch only.
 -f : Force continuation for looped dependency.
 -G : Use prebuilt packages for ports with the default configurations.
 -g : Keep pkg(8) and dialog4ports(1) untouched.
 -I : Only interactive ports are (re)installed.
 -j : Delete unneeded leaf and obsolete packages before (re)installation of needed ports
 -k : Keep portsreinstall itself untouched.
 -l : Use legacy-style packages when prebuilt modern-style packages are missing.
 -n : No operation is carried out (just for seeing what will be done).
 -q : Only new ports and their run-time requirements are reinstalled.
 -s : Build of vulnerable ports are avoided by triggering errors.
 -X : Deselect all deinstallation candidates.
 -x : No execution of pre/post-(de)installation scripts
 -Y : Select all deinstallation candidates.
 <Group 5: Saved and transferred to restarted runs, renewable by -N option>
 -O glob1[:glob2[:...]] : Reinstall only target ports themselves.
 -o : Ignore ports which are outside of target scopes of -O, -T or -t options.
 -T glob1[:glob2[:...]] : Reinstall only target ports and their requirements.
 -t glob1[:glob2[:...]] : Reinstall only target ports and their dependents.
 <Group 6: Saved and transferred to restarted runs, renewable by -L option>
 -P : Import settings from pkgtools.conf(5) as the secondary if exists.
 -p : Import settings from pkgtools.conf(5) as the primary if exists (default).
 -Q : Ignore pkgtools.conf(5) even if it exists.

 *NOTE*
 The configuration of options annotated as "saved and transferred to restarted runs" are saved in the temporary database by the first run after creating/cleaning the database. In the following runs, the corresponding option settings are loaded from the saved configuration if executed with no option or exactly the same option set as the saved one. Otherwise, the option settings are renewed for possible ones and the others are loaded from the saved configuration. Then the saved configuration is updated with the renewed settings.

[ARGUMENTS]
 command:
            do [all] (default) | [do] prepare | redo [all] | redo prepare
          | clean [normal] | clean force
          | reset [all] | reset keepopts | reset keepstatus
          | ok add globs... | ok del globs...
          | taboo add globs... | taboo del globs...
          | freeze add globs... | freeze del globs...
          | need add globs... | need del globs...
          | noneed add globs... | noneed del globs...
          | reselect leaves | reselect obsolete
          | save [dir] | load path
          | rmconf globs... | reconf globs... | forget globs...
          | escape globs... | restore globs...
          | pkgsanity [globs...]
          | packupgrade create | packupgrade crop [path] | packupgrade clean
          | make glob [target] [arguments...]
          | glob globs... | pkg globs... | options
          | show todo | show done | show resolved | show failure | show redo
          | show inst_by_pkg | show inst_built_default | show inst_built_custom
          | show taboo | show need | show noneed | show restored | show deleted
          | show fossil | show conflict | show moved
          | show build_conflict_pkgs | show inst_conflict_pkgs
          | show leaves [selected | unselected] | show obsolete [selected | unselected]
          | show requirements glob... | show dependents glob...
          | show initrequirements glob... | show initdependents glob...
          | show conflict_files glob... | show status glob...
          | show errormessage glob...

[DESCRIPTIONS]
 This utility is an alternative to portupgrade(1) and portmaster(8), and designed to be suitable for reinstallation of all packages after major version upgrade of the system or very long absence of ports upgrade.
 Usually, you can execute with no option nor argument. If portupgrade(1) is installed, compatibility with it is taken into account by importing pkgtools.conf(5) and rebuilding the package database.

[ROBUSTNESS AGAINST TERMINATION AND RESTART]
 Execution of "do", "redo" and "packupgrade" commands can be terminated at any points and restarted from there with the same options saved in the temporary database (independent among utilities). The saved options can be changed by the ways depending on the assigned groups of the options. Some options can be reset only by "redo" command. The options are reset to the default by "clean" and "reset all" commands.
eof
}
