#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/liboptions.sh for portsreinstall-upgrade
# - Command line options -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Database of options which are given at each run and not saved =============
# [Syntax of option databases]
# short_name, long_name, variable, default_value, set_value
# Columns are delimited by tab characters.
options_db_onetime ()
{
	cat << eof
h	help	opt_help_mode	0	1
h	short-help	opt_help_mode	0	1
H	long-help	opt_help_mode	0	2
V	show-version	opt_show_version	no	yes
a	batch-mode	opt_batch_mode	no	yes
J	just-save-options	opt_just_save_options	no	yes
M	reset-minor-options	opt_reset_minor_options	no	yes
S	no-opening-message	opt_no_opening_message	no	yes
eof
}

# ============= Database of options which are saved and renewable at each run =============
options_db_saved_and_renewable ()
{
	cat << eof
c	suppress-clean-obsolete-database	opt_suppress_obsolete_db_clean	no	yes
n	dry-run	opt_dry_run	no	yes
eof
}

# ============= Database of options which are saved and not renewable until the temporary database is cleaned =============
options_db_saved_and_non_renewable ()
{
	cat << eof
P	packages-dir	opt_packages_dir	''	:
eof
}

# ============= Regularize the option value =============
options_regularize ()
{
	opt_packages_dir=`fs_global_path "$opt_packages_dir"`
	opt_no_exec_inst_script=no
}
