#!/usr/bin/env awk
# ==============================================================================
# portsreinstall library script
# - Order the dependency of all ports to install/reinstall -
# Copyright (C) 2018-2022 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

BEGIN {
	it = 0;
	i = 0;
}
{
	if (NF == 0)
	{
		i = 0;
	}
	else
	{
		if (i == 0)
		{
			target = $0;
			sub (/\/requirements.all\.full$/, "", target);
			sub (/^\.\//, "", target);
			srcikey[it] = target;
			srckeyi[target] = it;
			it++;
		}
		else
		{
			src[it-1,i-1] = $0;
			srcimax[it-1] = srcsize[it-1] = i;
		}
		i++;
	}
}
END {
	ntargets = it;
	norder = 0;
	order_str = "";
	icycle = 0;
	lf_order_str = "";
	while (1)
	{
		is_operated = 0;
		for (it = 0; it < ntargets; it++)
		{
			if (!(it in srcikey)) continue;
			if (srcsize[it] > 0) continue;
			is_operated = 1;
			target = srcikey[it];
			delete srcikey[it];
			order[norder++] = target;
			order_str = order_str lf_order_str;
			order_str = sprintf ("%s%s", order_str, target);
			lf_order_str = "\n";
			for (jt = 0; jt < ntargets; jt++)
			{
				for (j = 0; j < srcimax[jt]; j++)
				{
					if ((jt,j) in src && src[jt,j] == target)
					{
						delete src[jt,j];
						srcsize[jt]--;
						break;
					}
				}
			}
		}
		if (is_operated == 0) break;
		icycle++;
	}
	reinst_order_list = sprintf ("%s%s", ENVIRON["DBDIR"], "/reinst_order.list.tmp");
	print order_str > reinst_order_list;
	unsatisfied = "";
	for (it = 0; it < ntargets; it++)
	{
		if (srcsize[it] == 0) continue;
		reqs = "";
		sp_reqs = "";
		for (i = 0; i < srcimax[it]; i++)
		{
			if ((it,i) in src)
			{
				reqs = reqs sp_reqs src[it,i];
				sp_reqs = ", ";
			}
		}
		unsatisfied = sprintf ("%s%s [%d] (%s)\n", unsatisfied, srcikey[it], srcsize[it], reqs);
	}
	if (unsatisfied != "")
	{
		unsatisfied_list = sprintf ("%s%s", ENVIRON["DBDIR"], "/unsatisfied.list");
		print unsatisfied > unsatisfied_list;
		exit 1;
	}
}
