/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.core.text.TextSearchEngine;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.TextSearchResultCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TextSearchOperation
extends WorkspaceModifyOperation {
    public static final int NO_PRIORITY_CHANGE = -1;
    private TextSearchResultCollector fCollector;
    private MatchLocator fMatchLocator;
    private ISearchScope fScope;
    private IStatus fStatus;
    private IWorkspace fWorkspace;

    public TextSearchOperation(IWorkspace workspace, String pattern, boolean isCaseSensitive, boolean isRegexSearch, ISearchScope scope, TextSearchResultCollector collector) {
        super(null);
        Assert.isNotNull((Object)collector);
        this.fWorkspace = workspace;
        this.fMatchLocator = new MatchLocator(pattern, isCaseSensitive, isRegexSearch);
        this.fScope = scope;
        this.fCollector = collector;
        this.fCollector.setOperation(this);
    }

    protected void execute(IProgressMonitor monitor) {
        this.fCollector.setProgressMonitor(monitor);
        TextSearchEngine engine = new TextSearchEngine();
        this.fStatus = engine.search(this.fWorkspace, this.fScope, false, this.fCollector, this.fMatchLocator);
    }

    ImageDescriptor getImageDescriptor() {
        return SearchPluginImages.DESC_OBJ_TSEARCH_DPDN;
    }

    String getPattern() {
        return this.fMatchLocator.getPattern();
    }

    String getPluralLabelPattern() {
        String pattern = this.fMatchLocator.getPattern();
        if (pattern == null || pattern.length() < 1) {
            return SearchMessages.getFormattedString((String)"FileSearchOperation.pluralLabelPatternPostfix", (Object[])new String[]{"{0}", this.fScope.getDescription()});
        }
        return SearchMessages.getFormattedString((String)"TextSearchOperation.pluralLabelPatternPostfix", (Object[])new String[]{this.fMatchLocator.getPattern(), "{0}", this.fScope.getDescription()});
    }

    String getSingularLabel() {
        String pattern = this.fMatchLocator.getPattern();
        if (pattern == null || pattern.length() < 1) {
            return SearchMessages.getFormattedString((String)"FileSearchOperation.singularLabelPostfix", (Object[])new String[]{this.fScope.getDescription()});
        }
        return SearchMessages.getFormattedString((String)"TextSearchOperation.singularLabelPostfix", (Object[])new String[]{this.fMatchLocator.getPattern(), this.fScope.getDescription()});
    }

    IStatus getStatus() {
        return this.fStatus;
    }

    void searchInFile(IFile file, ITextSearchResultCollector collector) {
        TextSearchEngine engine = new TextSearchEngine();
        TextSearchScope scope = new TextSearchScope("");
        scope.add((IResource)file);
        scope.addExtension("*");
        this.fStatus = engine.search(this.fWorkspace, (ISearchScope)scope, false, collector, this.fMatchLocator);
    }
}

