/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.ui.text;

import java.text.MessageFormat;
import jp.gr.java_conf.ussiy.app.propsearch.search.ui.text.FileSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FileSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private final Match[] EMPTY_ARR = new Match[0];
    private FileSearchQuery fQuery;

    public FileSearchResult(FileSearchQuery job) {
        this.fQuery = job;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            FileEditorInput fi = (FileEditorInput)ei;
            return this.getMatches(fi.getFile());
        }
        return this.EMPTY_ARR;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return SearchPluginImages.DESC_OBJ_TSEARCH_DPDN;
    }

    public String getLabel() {
        if (this.getMatchCount() == 1) {
            return this.fQuery.getSingularLabel();
        }
        return MessageFormat.format(this.fQuery.getPluralPattern(), new Integer(this.getMatchCount()));
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            FileEditorInput fi = (FileEditorInput)ei;
            return match.getElement().equals(fi.getFile());
        }
        return false;
    }
}

