/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.ui.text;

import jp.gr.java_conf.ussiy.app.propsearch.search.ui.text.FileContentProvider;
import jp.gr.java_conf.ussiy.app.propsearch.search.ui.text.FileSearchPage;
import jp.gr.java_conf.ussiy.app.propsearch.search.ui.text.FileSearchResult;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.SearchPreferencePage;

public class FileTableContentProvider
extends FileContentProvider
implements IStructuredContentProvider {
    private FileSearchPage fPage;

    public FileTableContentProvider(FileSearchPage page) {
        this.fPage = page;
    }

    public void clear() {
        this.getViewer().refresh();
    }

    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        boolean tableLimited = SearchPreferencePage.isTableLimited();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    viewer.update(updatedElements[i], null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < SearchPreferencePage.getTableLimit()) {
                    viewer.add(updatedElements[i]);
                }
            } else {
                viewer.remove(updatedElements[i]);
            }
            ++i;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof FileSearchResult) {
            Object[] elements = ((FileSearchResult)((Object)inputElement)).getElements();
            int tableLimit = SearchPreferencePage.getTableLimit();
            if (SearchPreferencePage.isTableLimited() && elements.length > tableLimit) {
                Object[] shownElements = new Object[tableLimit];
                System.arraycopy(elements, 0, shownElements, 0, tableLimit);
                return shownElements;
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof FileSearchResult) {
            this.fResult = (FileSearchResult)((Object)newInput);
        }
    }
}

