/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.Msgs;
import com.trend.iwss.jscan.runtime.Session;
import com.trend.iwss.jscan.runtime.StubAppletDisplay;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;

public class BaseDialog
extends Dialog
implements WindowListener {
    public static final int PANEL_WIDTH = 400;
    public static final int PANEL_HEIGHT = 150;
    private final Object disposeLock = new Object();
    private Session m_ses;
    private boolean m_disposed = false;
    private Frame m_owner;

    public BaseDialog(Frame owner, Session ses) {
        super(owner, BaseDialog.getMsg(ses, "instr.dialog.title.applet_alert"), true);
        this.m_owner = owner;
        this.m_ses = ses;
        this.addWindowListener(this);
        this.setSize(400, 150);
        this.setLayout(new BorderLayout(10, 10));
    }

    protected boolean canDisplay() {
        BaseDialog.syserr("BaseDialog: owner frame is a " + this.m_owner.getClass().getName());
        return true;
    }

    protected String getMsg(String tag) {
        return BaseDialog.getMsg(this.m_ses, tag);
    }

    protected static String getMsg(Session ses, String tag) {
        if (null != ses) {
            return ses.getMsg(tag);
        }
        return Msgs.getDefaultMsg(tag);
    }

    protected static Frame getActiveFrame(Session ses) {
        Frame fr = ses.getActiveFrame();
        if (null != fr) {
            return fr;
        }
        return new Frame();
    }

    private void doDisplay() {
        if (null != this.m_ses) {
            this.m_ses.addOpenDialog(this);
        }
        this.pack();
        StubAppletDisplay.setDialogPosition(this, this, 150, 400);
        this.show();
        if (null != this.m_ses) {
            this.m_ses.removeOpenDialog(this);
        }
    }

    protected void displayDialog() {
        if (this.m_disposed) {
            BaseDialog.syserr("BaseDialog: display() called for disposed dialog");
            return;
        }
        if (!this.canDisplay()) {
            BaseDialog.syserr("BaseDialog: not displaying: m_owner.isDisplayable() == " + this.m_owner.isDisplayable());
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.doDisplay();
        } else {
            this.dispatch();
        }
    }

    private void dispatch() {
        Runnable act = new Runnable(){

            public void run() {
                BaseDialog.this.doDisplay();
            }
        };
        try {
            EventQueue.invokeAndWait(act);
        }
        catch (InterruptedException e) {
            BaseDialog.syserr("BaseDialog: dispatch(): InterruptedException: " + e);
        }
        catch (InvocationTargetException e) {
            BaseDialog.syserr("BaseDialog: InvocationTargetException in displayDialog");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.m_disposed) {
                return;
            }
            this.m_disposed = true;
            super.dispose();
        }
    }

    protected static void syserr(String msg) {
        System.err.println(msg);
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

