/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.NetworkPolicyRuntime;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public final class FileIOPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime = FileIOPolicyRuntime.class$("com.trend.iwss.jscan.runtime.FileIOPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime);
    public static final String NAME = "FileIO";
    public static final String PROP_PREFIX = "file";
    public static final Factory FACT = new Factory("FileIO");
    public static final String ENC_BACKSLASH = "%5c%";
    public static final String CFG_FILEIO_CATEGORYSFX_STATE_BOOL = ".state";
    public static final String CFG_FILEIO_CATEGORYSFX_EXCLUDE_LIST = ".ex_list";
    public static final String CFG_FILEIO_CATEGORYSFX_INCLUDE_LIST = ".in_list";
    public static final Category CATEGORY_READ = new Category("read", "instr.action.file.read");
    public static final Category CATEGORY_WRITE = new Category("write", "instr.action.file.write");
    public static final Category CATEGORY_DESTRUCTIVE = new Category("destructive", "instr.action.file.destructive", "instr.action.file.destructive_alt");
    public static final Category CATEGORY_NONDESTRUCTIVE = new Category("nondestructive", "instr.action.file.nondestructive", "instr.action.file.nondestructive_alt");
    public static final Category CATEGORY_DONT_INSTRUMENT = new Category("dont_instrument", null);
    public static final Category CATEGORY_UNKNOWN = new Category("unknown", null);
    public static final String METH_INIT = "<init>";
    public static final String METH_CLINIT = "<clinit>";
    private static final MethodRefMatcher MATCH_FILE = MethodRefMatcher.make("java/io/File");
    private static final MethodRefMatcher MATCH_FILE_OBJECT_IGNORE = MethodRefMatcher.make("java/io/File", new String[]{"getClass", "clone", "wait", "finalize", "notify", "notifyAll"});
    private static final MethodRefMatcher MATCH_FILE_IGNORE = MethodRefMatcher.make("java/io/File", new String[]{"<init>", "<clinit>", "isAbsolute", "getAbsolutePath", "getAbsoluteFile", "getName", "compareTo", "getParent", "getParentFile", "getPath", "setReadOnly", "toURI", "toURL", "hashCode", "toString", "equals"});
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set();
    private static final MethodRefMatcher MATCH_FILE_NONDESTRUCTIVE = MATCHERS.make("java/io/File", new String[]{"canRead", "canWrite", "exists", "isDirectory", "isFile", "lastModified", "length", "isHidden", "getCanonicalPath", "getCanonicalFile", "listRoots", "listFiles", "list"});
    private static final MethodRefMatcher MATCH_FILE_DESTRUCTIVE = MATCHERS.make("java/io/File", new String[]{"delete", "mkdir", "deleteOnExit", "mkdirs", "createNewFile", "createTempFile", "setLastModified", "renameTo"});
    private static final String[] ARGS_FILE_AND_STRING = new String[]{"(Ljava/io/File;*", "(Ljava/lang/String;*"};
    private static final MethodRefMatcher.Set READ_MATCHERS = MATCHERS.makeSet("java/io/");
    private static final MethodRefMatcher MATCH_READ_FIS = READ_MATCHERS.make("java/io/FileInputStream", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_READ_FR = READ_MATCHERS.make("java/io/FileReader", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_READ_RAF = READ_MATCHERS.make("java/io/RandomAccessFile", new String[]{"<init>", "read*", "seek", "skipBytes"});
    private static final MethodRefMatcher.Set WRITE_MATCHERS = MATCHERS.makeSet("java/io/");
    private static final MethodRefMatcher MATCH_WRITE_FOS = WRITE_MATCHERS.make("java/io/FileOutputStream", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_WRITE_FW = WRITE_MATCHERS.make("java/io/FileWriter", "<init>", ARGS_FILE_AND_STRING);
    private static final MethodRefMatcher MATCH_WRITE_RAF = WRITE_MATCHERS.make("java/io/RandomAccessFile", new String[]{"<init>", "write*", "setLength"});
    private static final MethodRefMatcher.Set PRE_MATCHERS_INIT = new MethodRefMatcher.Set("java/io/");
    private static final MethodRefMatcher PRE_MATCH_FIS_INIT = PRE_MATCHERS_INIT.make("java/io/FileInputStream", "<init>");
    private static final MethodRefMatcher PRE_MATCH_FR_INIT = PRE_MATCHERS_INIT.make("java/io/FileReader", "<init>");
    private static final MethodRefMatcher PRE_MATCH_FOS_INIT = PRE_MATCHERS_INIT.make("java/io/FileOutputStream", "<init>");
    private static final MethodRefMatcher PRE_MATCH_FW_INIT = PRE_MATCHERS_INIT.make("java/io/FileWriter", "<init>");
    private static final MethodRefMatcher PRE_MATCH_RAF_INIT = PRE_MATCHERS_INIT.make("java/io/RandomAccessFile", "<init>");
    private static final MethodRefMatcher PRE_MATCH_URL_CONNECTION = MethodRefMatcher.make("java/net/URLConnection", new String[]{"<init>", "connect"});
    private static final MethodRefMatcher PRE_MATCH_URL = MethodRefMatcher.make("java/net/URL", new String[]{"<init>", "openConnection", "openStream", "getContent"});
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$FileIOPolicyRuntime;

    FileIOPolicyRuntime(Session ses) {
        super(NAME, PROP_PREFIX, ses);
    }

    public static void preFilter(CallContext ctx) {
        PolicyRuntime.preFilter(ctx, FACT);
    }

    public static void postFilter(CallContext ctx) {
        PolicyRuntime.postFilter(ctx, FACT);
    }

    public static Category getCategory(String className, String methodName, String desc) {
        Category category = MATCH_FILE.match(className, methodName, desc) ? (MATCH_FILE_IGNORE.match(className, methodName, desc) ? CATEGORY_DONT_INSTRUMENT : (MATCH_FILE_OBJECT_IGNORE.match(className, methodName, desc) ? CATEGORY_DONT_INSTRUMENT : (MATCH_FILE_DESTRUCTIVE.match(className, methodName, desc) ? CATEGORY_DESTRUCTIVE : (MATCH_FILE_NONDESTRUCTIVE.match(className, methodName, desc) ? CATEGORY_NONDESTRUCTIVE : CATEGORY_UNKNOWN)))) : (READ_MATCHERS.match(className, methodName, desc) ? CATEGORY_READ : (WRITE_MATCHERS.match(className, methodName, desc) ? CATEGORY_WRITE : null));
        return category;
    }

    void _preFilter(CallContext ctx) {
        URL url;
        String fn;
        String mname = ctx.getRefName();
        Category category = FileIOPolicyRuntime.getCategory(ctx.getClassName(), mname, ctx.getRefDesc());
        String filename = null;
        if (MATCH_FILE.match(ctx)) {
            File file = (File)ctx.getTarget();
            filename = file != null ? file.getPath() : FileIOPolicyRuntime.getFilenameFromArg(ctx, 0);
        } else if (PRE_MATCHERS_INIT.match(ctx)) {
            filename = FileIOPolicyRuntime.getFilenameFromArg(ctx, 0);
            if (PRE_MATCH_RAF_INIT.match(ctx)) {
                category = ctx.getArg(1).getObjectValue().equals("r") ? CATEGORY_READ : CATEGORY_WRITE;
            }
        } else if (PRE_MATCH_URL_CONNECTION.match(ctx)) {
            URL url2 = null;
            if (mname.equals(METH_INIT)) {
                url2 = (URL)ctx.getArg(0).getObjectValue();
            } else if (mname.equals("connect")) {
                url2 = ((URLConnection)ctx.getTarget()).getURL();
            }
            String fn2 = NetworkPolicyRuntime.getFileProtocolFilename(url2);
            if (null != fn2) {
                filename = fn2;
                category = CATEGORY_READ;
            }
        } else if (PRE_MATCH_URL.match(ctx) && null != (fn = NetworkPolicyRuntime.getFileProtocolFilename(url = (URL)ctx.getTarget()))) {
            filename = fn;
            category = CATEGORY_READ;
        }
        if (null == category) {
            return;
        }
        if (null == category.msgTag) {
            return;
        }
        if (this.allowAction(category, filename = FileIOPolicyRuntime.canonicalizeFilePath(filename))) {
            return;
        }
        this.doStopAction(category, filename, ctx);
    }

    void _postFilter(CallContext ctx) {
    }

    private void doStopAction(Category category, String filename, CallContext ctx) {
        String msgTag;
        String[] params;
        String mname = ctx.getRefName();
        if (null != filename) {
            params = new String[]{filename, mname};
            msgTag = category.msgTag;
        } else {
            params = new String[]{mname};
            msgTag = category.msgTagAlt;
        }
        this.stopAction(msgTag, params);
    }

    private static String getFilenameFromArg(CallContext ctx, int argIdx) {
        if (ctx.getNumArgs() <= argIdx) {
            return null;
        }
        Object obj = ctx.getArg(argIdx).getObjectValue();
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof File) {
            return ((File)obj).getPath();
        }
        return null;
    }

    private static String canonicalizeFilePath(String path) {
        if (null == path) {
            return null;
        }
        try {
            File file = new File(path);
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            return path;
        }
    }

    private boolean allowAction(Category category, String filename) {
        boolean enabled = this.getBoolPolicyProp(category.name + CFG_FILEIO_CATEGORYSFX_STATE_BOOL, false);
        if (enabled) {
            String pat = this.getStrPolicyProp(category.name + CFG_FILEIO_CATEGORYSFX_EXCLUDE_LIST, "");
            return !this.matchFile(filename, pat);
        }
        String pat = this.getStrPolicyProp(category.name + CFG_FILEIO_CATEGORYSFX_INCLUDE_LIST, "");
        return this.matchFile(filename, pat);
    }

    private static String canonicalizePath(String path) {
        StringBuffer buf = new StringBuffer();
        boolean sepSeen = false;
        char ch = '\u0000';
        for (int i = 0; i < path.length(); ++i) {
            ch = path.charAt(i);
            if (ch != File.separatorChar) {
                buf.append(ch);
                sepSeen = false;
                continue;
            }
            if (sepSeen) continue;
            buf.append(ch);
            sepSeen = true;
        }
        if (File.separatorChar != ch) {
            buf.append(File.separatorChar);
        }
        return buf.toString();
    }

    private boolean matchFile(String fl, String pats) {
        if (null == fl) {
            return false;
        }
        String file = FileIOPolicyRuntime.canonicalizePath(fl);
        String patterns = FileIOPolicyRuntime.replaceIn(pats, ENC_BACKSLASH, "\\");
        if (File.separatorChar == '\\') {
            file = file.toLowerCase();
            patterns = patterns.toLowerCase();
        }
        StringTokenizer tokens = new StringTokenizer(patterns, ";");
        while (tokens.hasMoreTokens()) {
            String s;
            int i;
            String pat = tokens.nextToken();
            char suffix = '\u0000';
            if (pat.endsWith(File.separator + "*") || pat.endsWith(File.separator + "-")) {
                suffix = pat.charAt(pat.length() - 1);
                pat = pat.substring(0, pat.length() - 1);
            }
            if (!pat.endsWith(File.separator)) {
                pat = pat + File.separator;
            }
            if (!(suffix == '-' ? file.startsWith(pat) : (suffix == '*' ? file.startsWith(pat) && ((i = (s = file.substring(pat.length(), file.length())).indexOf(File.separatorChar)) == -1 || i == s.length() - 1) : pat.equals(file)))) continue;
            return true;
        }
        return false;
    }

    private static String replaceIn(String val, String target, String rep) {
        int idx = val.indexOf(target);
        if (-1 == idx) {
            return val;
        }
        StringBuffer sb = new StringBuffer();
        int tlen = target.length();
        int strtIdx = 0;
        do {
            sb.append(val.substring(strtIdx, idx));
            sb.append(rep);
            strtIdx = idx + tlen;
        } while (val.length() > strtIdx && -1 != (idx = val.indexOf(target, strtIdx)));
        if (val.length() > strtIdx) {
            sb.append(val.substring(strtIdx));
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String ctxKey) {
            super(ctxKey);
        }

        PolicyRuntime make(Session ses) {
            return new FileIOPolicyRuntime(ses);
        }
    }

    public static class Category {
        public String name;
        public String msgTag;
        public String msgTagAlt;

        private Category(String nm, String tag) {
            this(nm, tag, (String)null);
        }

        private Category(String nm, String tag, String tagAlt) {
            this.name = nm;
            this.msgTag = tag;
            this.msgTagAlt = null != tagAlt ? tagAlt : tag;
        }
    }
}

