/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.RuntimeClassRef;
import java.util.Enumeration;
import java.util.Vector;

public class MethodRefMatcher {
    private MatchTarget[] m_classNames;
    private MatchTarget[] m_methodNames;
    private MatchTarget[] m_argDescs;

    public static MethodRefMatcher make(String className) {
        return MethodRefMatcher.make(new String[]{className}, null, null);
    }

    public static MethodRefMatcher make(String className, String methodName) {
        return MethodRefMatcher.make(new String[]{className}, new String[]{methodName}, null);
    }

    public static MethodRefMatcher make(String className, String methodName, String argDesc) {
        return MethodRefMatcher.make(new String[]{className}, new String[]{methodName}, new String[]{argDesc});
    }

    public static MethodRefMatcher make(String className, String[] methodNames) {
        return MethodRefMatcher.make(new String[]{className}, methodNames, null);
    }

    public static MethodRefMatcher make(String[] classNames, String methodName) {
        return MethodRefMatcher.make(classNames, new String[]{methodName}, null);
    }

    public static MethodRefMatcher make(String[] classNames) {
        return MethodRefMatcher.make(classNames, null, null);
    }

    public static MethodRefMatcher make(String[] classNames, String[] methodNames) {
        return MethodRefMatcher.make(classNames, methodNames, null);
    }

    public static MethodRefMatcher make(String[] classNames, String[] methodNames, String[] argDescs) {
        return new MethodRefMatcher(classNames, methodNames, argDescs);
    }

    private MethodRefMatcher(String[] classNames, String[] methodNames, String[] argDescs) {
        this.m_classNames = MatchTarget.make(classNames);
        this.m_methodNames = MatchTarget.make(methodNames);
        this.m_argDescs = MatchTarget.make(argDescs);
    }

    public boolean match(RuntimeClassRef method) {
        return this.match(method.getClassName(), method.getRefName(), method.getRefDesc());
    }

    public boolean match(String className, String methodName, String refDesc) {
        if (!MatchTarget.match(className, this.m_classNames)) {
            return false;
        }
        if (!MatchTarget.match(methodName, this.m_methodNames)) {
            return false;
        }
        return MatchTarget.match(refDesc, this.m_argDescs);
    }

    public boolean matchClass(String className) {
        return MatchTarget.match(className, this.m_classNames);
    }

    public boolean hasClass() {
        return null != this.m_classNames;
    }

    public boolean hasMethod() {
        return null != this.m_methodNames;
    }

    public boolean hasArg() {
        return null != this.m_argDescs;
    }

    public static class MatchTarget {
        private final String m_original;
        private final String m_target;
        private final boolean m_useStartsWith;
        private final boolean m_matchedResult;

        public static MatchTarget[] make(String[] targets) {
            if (null == targets) {
                return null;
            }
            MatchTarget[] ret = new MatchTarget[targets.length];
            for (int ii = 0; ii < targets.length; ++ii) {
                ret[ii] = MatchTarget.make(targets[ii]);
            }
            return ret;
        }

        public static MatchTarget make(String target) {
            return new MatchTarget(target);
        }

        private MatchTarget(String targ) {
            this.m_original = targ;
            int strt = 0;
            int end = targ.length();
            if ('-' == targ.charAt(0)) {
                this.m_matchedResult = false;
                ++strt;
            } else {
                this.m_matchedResult = true;
            }
            if ('*' == targ.charAt(end - 1)) {
                this.m_useStartsWith = true;
                --end;
            } else {
                this.m_useStartsWith = false;
            }
            this.m_target = targ.substring(strt, end);
        }

        public String getTargetValue() {
            return this.m_original;
        }

        public boolean getMatchedValue() {
            return this.m_matchedResult;
        }

        public static boolean match(String val, MatchTarget[] targets) {
            if (null == targets) {
                return true;
            }
            if (null == val) {
                return false;
            }
            for (int ii = 0; ii < targets.length; ++ii) {
                if (!targets[ii].matchInner(val)) continue;
                return targets[ii].getMatchedValue();
            }
            return false;
        }

        public boolean match(String val) {
            return this.matchInner(val) ? this.m_matchedResult : !this.m_matchedResult;
        }

        private boolean matchInner(String val) {
            return this.m_useStartsWith ? val.startsWith(this.m_target) : this.m_target.equalsIgnoreCase(val);
        }
    }

    public static class Set {
        private final Vector m_matchers = new Vector();
        private final Vector m_sets = new Vector();
        private final String m_prefix;

        public Set() {
            this.m_prefix = null;
        }

        public Set(String prefix) {
            this.m_prefix = prefix;
        }

        public Set makeSet() {
            Set set = new Set();
            this.m_sets.addElement(set);
            return set;
        }

        public Set makeSet(String prefix) {
            Set set = new Set(prefix);
            this.m_sets.addElement(set);
            return set;
        }

        public MethodRefMatcher make(String className) {
            return this.make(new String[]{className}, null, null);
        }

        public MethodRefMatcher make(String[] classNames) {
            return this.make(classNames, null, null);
        }

        public MethodRefMatcher make(String className, String methodName) {
            return this.make(new String[]{className}, new String[]{methodName}, null);
        }

        public MethodRefMatcher make(String className, String methodName, String argDesc) {
            return this.make(new String[]{className}, new String[]{methodName}, new String[]{argDesc});
        }

        public MethodRefMatcher make(String className, String methodName, String[] argDesc) {
            return this.make(new String[]{className}, new String[]{methodName}, argDesc);
        }

        public MethodRefMatcher make(String className, String[] methodNames) {
            return this.make(new String[]{className}, methodNames, null);
        }

        public MethodRefMatcher make(String className, String[] methodNames, String argDesc) {
            return this.make(new String[]{className}, methodNames, new String[]{argDesc});
        }

        public MethodRefMatcher make(String[] classNames, String methodName) {
            return this.make(classNames, new String[]{methodName}, null);
        }

        public MethodRefMatcher make(String[] classNames, String[] methodNames, String[] argDescs) {
            MethodRefMatcher mrm = new MethodRefMatcher(classNames, methodNames, argDescs);
            this.m_matchers.addElement(mrm);
            return mrm;
        }

        public boolean matchClass(String className) {
            if (null != this.m_prefix && !className.startsWith(this.m_prefix)) {
                return false;
            }
            Enumeration it = this.m_sets.elements();
            while (it.hasMoreElements()) {
                Set set = (Set)it.nextElement();
                if (!set.matchClass(className)) continue;
                return true;
            }
            it = this.m_matchers.elements();
            while (it.hasMoreElements()) {
                MethodRefMatcher mrm = (MethodRefMatcher)it.nextElement();
                if (!mrm.matchClass(className)) continue;
                return true;
            }
            return false;
        }

        public boolean match(String className, String methodName, String refDesc) {
            if (null != this.m_prefix && !className.startsWith(this.m_prefix)) {
                return false;
            }
            Enumeration it = this.m_sets.elements();
            while (it.hasMoreElements()) {
                Set set = (Set)it.nextElement();
                if (!set.match(className, methodName, refDesc)) continue;
                return true;
            }
            it = this.m_matchers.elements();
            while (it.hasMoreElements()) {
                MethodRefMatcher mrm = (MethodRefMatcher)it.nextElement();
                if (!mrm.match(className, methodName, refDesc)) continue;
                return true;
            }
            return false;
        }

        public boolean match(RuntimeClassRef method) {
            return this.match(method.getClassName(), method.getRefName(), method.getRefDesc());
        }

        public MethodRefMatcher getMatch(String className, String methodName, String refDesc) {
            if (null != this.m_prefix && !className.startsWith(this.m_prefix)) {
                return null;
            }
            Enumeration it = this.m_sets.elements();
            while (it.hasMoreElements()) {
                Set set = (Set)it.nextElement();
                MethodRefMatcher mrm = set.getMatch(className, methodName, refDesc);
                if (null == mrm) continue;
                return mrm;
            }
            it = this.m_matchers.elements();
            while (it.hasMoreElements()) {
                MethodRefMatcher mrm = (MethodRefMatcher)it.nextElement();
                if (!mrm.match(className, methodName, refDesc)) continue;
                return mrm;
            }
            return null;
        }

        public MethodRefMatcher getMatch(RuntimeClassRef method) {
            return this.getMatch(method.getClassName(), method.getRefName(), method.getRefDesc());
        }
    }
}

