/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.RuntimeValue;
import com.trend.iwss.jscan.runtime.Session;
import java.util.Vector;

public final class MiscPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime = MiscPolicyRuntime.class$("com.trend.iwss.jscan.runtime.MiscPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime);
    public static final String NAME = "Misc";
    public static final String PROP_PREFIX = "misc";
    public static final Factory FACT = new Factory("Misc");
    public static final String CFG_MISC_BLOCK_COM_MS_PKGS_BOOL = "block_com_ms_pkgs";
    public static final String CFG_MISC_BLOCK_NETSCAPE_PKGS_BOOL = "block_netscape_pkgs";
    private static final String[] SYSTEM_PROPS_GENERAL = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.compiler", "file.separator", "path.separator", "line.separator", "os.name", "os.arch", "os.version"};
    private static final String[] SYSTEM_PROPS_SENSITIVE = new String[]{"java.home", "java.class.path", "java.library.path", "java.io.tmpdir", "java.ext.dirs", "user.name", "user.home", "user.dir"};
    private static final Vector SYSTEM_PROPERTIES_GENERAL = MiscPolicyRuntime.arrayToVector(SYSTEM_PROPS_GENERAL);
    private static final Vector SYSTEM_PROPERTIES_SENSITIVE = MiscPolicyRuntime.arrayToVector(SYSTEM_PROPS_SENSITIVE);
    private static final String STRING_ARG = "(Ljava/lang/String;*";
    private static final String RUNTIME_CLASS = "java/lang/Runtime";
    private static final String SYSTEM_CLASS = "java/lang/System";
    private static final String[] RUNTIME_METHODS_OTHER = new String[]{"exit", "gc", "halt", "addShutdownHook", "removeShutdownHook", "runFinalization", "runFinalizersOnExit", "traceInstructions", "traceMethodCalls"};
    private static final String[] RUNTIME_METHODS_LOAD = new String[]{"load", "loadLibrary"};
    private static final String[] SYSTEM_METHODS_OTHER = new String[]{"exit", "gc", "inheritedChannel", "runFinalization", "setProperties", "getProperties"};
    private static final String[] SYSTEM_METHODS_PROPERTY_SET = new String[]{"clearProperty", "setProperty"};
    private static final String[] SYSTEM_METHODS_LOAD = new String[]{"load", "loadLibrary"};
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set();
    public static final MethodRefMatcher MATCH_JAVA_RUNTIME_EXEC = MATCHERS.make("java/lang/Runtime", "exec");
    public static final MethodRefMatcher MATCH_JAVA_RUNTIME_OTHER = MATCHERS.make("java/lang/Runtime", RUNTIME_METHODS_OTHER);
    public static final MethodRefMatcher MATCH_JAVA_RUNTIME_LOAD = MATCHERS.make("java/lang/Runtime", RUNTIME_METHODS_LOAD, "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_JAVA_SYSTEM_OTHER = MATCHERS.make("java/lang/System", SYSTEM_METHODS_OTHER);
    public static final MethodRefMatcher MATCH_JAVA_SYSTEM_LOAD = MATCHERS.make("java/lang/System", SYSTEM_METHODS_LOAD, "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_SYS_SETPROPERTY = MATCHERS.make("java/lang/System", SYSTEM_METHODS_PROPERTY_SET, "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_SYS_GETENV = MATCHERS.make("java/lang/System", "getenv", "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_SYS_GETPROPERTY = MATCHERS.make("java/lang/System", "getProperty", "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_MS_CLASSES = MATCHERS.make("com/ms/*");
    public static final MethodRefMatcher MATCH_NETSCAPE_CLASSES = MATCHERS.make(new String[]{"-netscape/security/*", "netscape/*"});
    private boolean m_blockComMsPkgUse = this.getBoolPolicyProp("block_com_ms_pkgs", true);
    private boolean m_blockNetscapePkgUse = this.getBoolPolicyProp("block_netscape_pkgs", true);
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime;

    MiscPolicyRuntime(Session ses) {
        super(NAME, PROP_PREFIX, ses);
    }

    public static void preFilter(CallContext ctx) {
        PolicyRuntime.preFilter(ctx, FACT);
    }

    public static void postFilter(CallContext ctx) {
        PolicyRuntime.postFilter(ctx, FACT);
    }

    void _preFilter(CallContext ctx) {
        String cname = ctx.getClassName();
        String mname = ctx.getRefName();
        MethodRefMatcher mrm = MATCHERS.getMatch(ctx);
        if (MATCH_MS_CLASSES == mrm) {
            if (!this.m_blockComMsPkgUse) {
                return;
            }
            String param = ctx.getClassName() + "#" + mname + "()";
            this.stopAction("instr.action.invoke", param);
        } else if (MATCH_NETSCAPE_CLASSES == mrm) {
            if (!this.m_blockNetscapePkgUse) {
                return;
            }
            String param = ctx.getClassName() + "#" + mname + "()";
            this.stopAction("instr.action.invoke", param);
        } else if (MATCH_JAVA_RUNTIME_EXEC == mrm) {
            String execName = MiscPolicyRuntime.getExecTarget(ctx);
            this.stopAction("instr.action.runtime.exec", execName);
        } else if (MATCH_SYS_GETPROPERTY == mrm) {
            String arg = MiscPolicyRuntime.getStrArg(ctx);
            if (!this.enforceForProperty(arg)) {
                return;
            }
            String[] params = new String[]{cname, mname, arg};
            this.stopAction("instr.action.invoke_sys_arg", params);
        } else if (mrm.hasArg()) {
            String arg = MiscPolicyRuntime.getStrArg(ctx);
            String[] params = new String[]{cname, mname, arg};
            this.stopAction("instr.action.invoke_sys_arg", params);
        } else {
            String[] params = new String[]{cname, mname};
            this.stopAction("instr.action.invoke_sys_noarg", params);
        }
    }

    void _postFilter(CallContext ctx) {
    }

    private boolean enforceForProperty(String arg) {
        String prop = arg.toLowerCase();
        if (SYSTEM_PROPERTIES_SENSITIVE.contains(prop)) {
            return true;
        }
        if (this.isEnforcementStrict()) {
            return true;
        }
        return this.isSensitiveTopLevel(arg) && !SYSTEM_PROPERTIES_GENERAL.contains(prop);
    }

    private boolean isSensitiveTopLevel(String arg) {
        return arg.startsWith("java.") || arg.startsWith("os.") || arg.startsWith("user.");
    }

    private static String getStrArg(CallContext ctx) {
        RuntimeValue rtv = ctx.getArg(0);
        if (null == rtv) {
            return "";
        }
        Object arg = rtv.getObjectValue();
        if (!(arg instanceof String)) {
            return "";
        }
        return (String)arg;
    }

    private static String getExecTarget(CallContext ctx) {
        RuntimeValue rtv = ctx.getArg(0);
        if (null == rtv) {
            return "";
        }
        Object arg = rtv.getObjectValue();
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof String[]) {
            String[] array = (String[])arg;
            if (0 == array.length) {
                return "";
            }
            return array[0];
        }
        return "";
    }

    private static Vector arrayToVector(String[] array) {
        Vector<String> ret = new Vector<String>();
        for (int ii = 0; ii < array.length; ++ii) {
            ret.addElement(array[ii]);
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String ctxKey) {
            super(ctxKey);
        }

        PolicyRuntime make(Session ses) {
            return new MiscPolicyRuntime(ses);
        }
    }
}

