/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PolicyProps {
    private final Properties m_props;

    public static PolicyProps make(String propString) {
        if (propString == null) {
            return new PolicyProps();
        }
        Properties props = new Properties();
        byte[] propBytes = PolicyProps.getAsciiBytes(propString);
        ByteArrayInputStream bin = new ByteArrayInputStream(propBytes);
        try {
            props.load(bin);
        }
        catch (IOException ex) {
            System.err.println("Error loading Policy properties");
            ex.printStackTrace();
        }
        return new PolicyProps(props);
    }

    public boolean hasProps() {
        return 0 < ((Hashtable)this.m_props).size();
    }

    public static byte[] getAsciiBytes(String stuff) {
        if (null == stuff || 0 == stuff.length()) {
            return new byte[0];
        }
        int len = stuff.length();
        byte[] ret = new byte[stuff.length()];
        for (int ii = 0; ii < len; ++ii) {
            ret[ii] = (byte)stuff.charAt(ii);
        }
        return ret;
    }

    public PolicyProps() {
        this.m_props = new Properties();
    }

    private PolicyProps(Properties props) {
        this.m_props = props;
    }

    public String getStrProp(String key, String dflt) {
        String pval = this.getProp(key);
        if (null == pval) {
            return dflt;
        }
        return pval;
    }

    public String getB64StrProp(String key, String dflt) {
        String b64val = this.getProp(key);
        if (null == b64val) {
            return dflt;
        }
        try {
            return new String(Base64.decode(b64val), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("UTF-8 encoding not recognized");
            e.printStackTrace();
            return dflt;
        }
    }

    public int getIntProp(String key, int dflt) {
        String pval = this.getProp(key);
        if (null == pval) {
            return dflt;
        }
        if ("".equals(pval)) {
            return dflt;
        }
        try {
            return Integer.parseInt(pval);
        }
        catch (NumberFormatException e) {
            System.err.println("The value for numeric configuration property \"" + key + "\" is invalid, using \"" + dflt + "\" as default value");
            return dflt;
        }
    }

    public boolean getBoolProp(String key, boolean dflt) {
        String pval = this.getProp(key);
        if (null == pval) {
            return dflt;
        }
        if ("".equals(pval)) {
            return dflt;
        }
        if ("yes".equalsIgnoreCase(pval)) {
            return true;
        }
        if ("no".equalsIgnoreCase(pval)) {
            return false;
        }
        if ("true".equalsIgnoreCase(pval)) {
            return true;
        }
        if ("false".equalsIgnoreCase(pval)) {
            return false;
        }
        if ("on".equalsIgnoreCase(pval)) {
            return true;
        }
        if ("off".equalsIgnoreCase(pval)) {
            return false;
        }
        if ("enable".equalsIgnoreCase(pval)) {
            return true;
        }
        if ("disable".equalsIgnoreCase(pval)) {
            return false;
        }
        if ("enabled".equalsIgnoreCase(pval)) {
            return true;
        }
        if ("disabled".equalsIgnoreCase(pval)) {
            return false;
        }
        System.err.println("The value for boolean configuration property \"" + key + "\" is invalid, using \"" + dflt + "\" as default value");
        return dflt;
    }

    public String getStrPolicyProp(String prefix, String pkey, String dflt) {
        String key = this.composeKey(prefix, pkey);
        return this.getStrProp(key, dflt);
    }

    public int getIntPolicyProp(String prefix, String pkey, int dflt) {
        String key = this.composeKey(prefix, pkey);
        return this.getIntProp(key, dflt);
    }

    public boolean getBoolPolicyProp(String prefix, String pkey, boolean dflt) {
        String key = this.composeKey(prefix, pkey);
        return this.getBoolProp(key, dflt);
    }

    private String getProp(String key) {
        if (0 == ((Hashtable)this.m_props).size()) {
            System.err.println("-- PolicyProps uninitialized on access of '" + key + "'");
        }
        return this.m_props.getProperty(key);
    }

    private String composeKey(String prefix, String key) {
        return prefix == null ? key : prefix + "." + key;
    }

    public void dbgDumpProps() {
        System.err.println("Current policy properties:");
        if (0 == ((Hashtable)this.m_props).size()) {
            System.err.println("\t(-none - uninitialized-)");
            return;
        }
        Enumeration iter = ((Hashtable)this.m_props).keys();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            String val = this.m_props.getProperty(key);
            System.err.println("\t" + key + ": " + val);
        }
    }
}

