/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.AlertDialog;
import com.trend.iwss.jscan.runtime.AllowDialog;
import com.trend.iwss.jscan.runtime.AppletTrapStopError;
import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.OkDialog;
import com.trend.iwss.jscan.runtime.PolicyProps;
import com.trend.iwss.jscan.runtime.Session;
import com.trend.iwss.jscan.runtime.StubAppletDisplay;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;

public abstract class PolicyRuntime {
    public static final String METH_PREFILTER = "preFilter";
    public static final String METH_POSTFILTER = "postFilter";
    public static final String PARAMDEF_PREFILTER = CallContext.ARG_POLICYFILTER;
    public static final String PARAMDEF_POSTFILTER = CallContext.ARG_POLICYFILTER;
    public static final String RUNTIME_PACKAGE_BASE = "com/trend/iwss/jscan/runtime";
    public static final String RUNTIME_URL_NASE = "/com/trend/iwss/jscan/runtime";
    public static final String CFG_MISC_PROMPT_USER_BOOL = "misc.prompt_user";
    public static final String CFG_MISC_NOTIFY_USER_BOOL = "misc.notify_user";
    public static final String CFG_MISC_NO_USER_INTERACTION_BOOL = "misc.no_user_interaction";
    public static final String CFG_MISC_MAX_OFFENCE_COUNT_INT = "misc.max_offense_cnt";
    public static final String CFG_MISC_STRICT_ENFORCEMENT = "misc.strict_enforcement";
    public static final String CFG_JSCAN_SESSION_ORIGIN_URI = "jscan.session.origin_uri";
    public static final String CFG_JSCAN_SESSION_POLICYNAME = "jscan.session.policyname";
    public static final String REPORT_START_TAG = "Report?";
    public static final String REPORT_REASON_TAG = "Reason=";
    public static final String REPORT_URI_TAG = "URI=";
    public static final String REPORT_CLASS_TAG = "class=";
    public static final String REPORT_POLICYNAME_TAG = "Policyname=";
    public static final String REPORT_AMP = "&";
    public static final String CLASS_STRING = "java.lang.String";
    private PolicyProps m_props;
    protected Session m_ses;
    protected String m_name;
    private String m_prefix;
    private String m_policyName;
    private String m_originURI;
    private int m_maxOffenses;
    private boolean m_noUserInteraction;
    private boolean m_doAllowDialog;
    private boolean m_doNotifyDialog;
    private boolean m_strictEnforcement;

    public static String classNameSlashNotation(Class cl) {
        String clName = cl.getName();
        return clName.replace('.', '/');
    }

    protected PolicyRuntime(String policyName, String propPrefix, Session session) {
        this.m_ses = session;
        this.m_props = this.m_ses.getProperties();
        this.m_name = policyName;
        this.m_prefix = propPrefix;
        this.m_policyName = this.getB64StrProp(CFG_JSCAN_SESSION_POLICYNAME, null);
        this.m_originURI = this.getStrProp(CFG_JSCAN_SESSION_ORIGIN_URI, null);
        this.m_noUserInteraction = this.getBoolProp(CFG_MISC_NO_USER_INTERACTION_BOOL, false);
        this.m_doAllowDialog = this.m_noUserInteraction ? false : this.getBoolProp(CFG_MISC_PROMPT_USER_BOOL, true);
        this.m_doNotifyDialog = this.m_noUserInteraction ? false : this.getBoolProp(CFG_MISC_NOTIFY_USER_BOOL, true);
        this.m_maxOffenses = this.getIntProp(CFG_MISC_MAX_OFFENCE_COUNT_INT, -1);
        this.m_strictEnforcement = this.getBoolProp(CFG_MISC_STRICT_ENFORCEMENT, false);
    }

    String getPolicyName() {
        return this.m_name;
    }

    boolean isEnforcementStrict() {
        return this.m_strictEnforcement;
    }

    abstract void _preFilter(CallContext var1);

    abstract void _postFilter(CallContext var1);

    static void preFilter(CallContext ctx, Factory fact) {
        Session ses = Session.get();
        PolicyRuntime policy = PolicyRuntime.accessInstance(fact, ses);
        if (ses.getStatus() == 1) {
            PolicyRuntime.syserr("-->> Invocation of " + ctx.toString() + " with STOP set");
            ses.stopCurrentThread();
            return;
        }
        try {
            policy._preFilter(ctx);
        }
        catch (Exception e) {
            if (e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            e.printStackTrace();
        }
    }

    static void postFilter(CallContext ctx, Factory fact) {
        Session ses = Session.get();
        PolicyRuntime policy = PolicyRuntime.accessInstance(fact, ses);
        try {
            policy._postFilter(ctx);
        }
        catch (Exception e) {
            if (e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            e.printStackTrace();
        }
    }

    boolean stopAction(String msgTag) {
        return this.stopAction(msgTag, (String[])null);
    }

    boolean stopAction(String msgTag, String param) {
        return this.stopAction(msgTag, new String[]{param});
    }

    boolean stopAction(String msgTag, String[] params) {
        String msgFmt = this.m_ses.getMsg(msgTag);
        String msg = MessageFormat.format(msgFmt, params);
        return this.stopActionInner(msg);
    }

    String getStrProp(String key, String dflt) {
        return this.m_props.getStrProp(key, dflt);
    }

    String getB64StrProp(String key, String dflt) {
        return this.m_props.getB64StrProp(key, dflt);
    }

    int getIntProp(String key, int dflt) {
        return this.m_props.getIntProp(key, dflt);
    }

    boolean getBoolProp(String key, boolean dflt) {
        return this.m_props.getBoolProp(key, dflt);
    }

    String getStrPolicyProp(String pkey, String dflt) {
        String key = this.composeKey(pkey);
        return this.getStrProp(key, dflt);
    }

    int getIntPolicyProp(String pkey, int dflt) {
        String key = this.composeKey(pkey);
        return this.getIntProp(key, dflt);
    }

    boolean getBoolPolicyProp(String pkey, boolean dflt) {
        String key = this.composeKey(pkey);
        return this.getBoolProp(key, dflt);
    }

    private static PolicyRuntime accessInstance(Factory fact, Session ses) {
        PolicyRuntime policy = (PolicyRuntime)ses.getKey(fact.getCtxKey());
        if (null == policy) {
            policy = fact.make(ses);
            ses.setKey(fact.getCtxKey(), policy);
        }
        return policy;
    }

    private boolean stopActionInner(String info) {
        boolean destroy = false;
        boolean silent = false;
        if (this.m_ses.getStatus() == 1) {
            PolicyRuntime.syserr("-->> Reinvocation with STOP set");
            this.m_ses.stopCurrentThread();
            return false;
        }
        if (this.m_doAllowDialog) {
            int act = this.showAllowDialog(info);
            if (act == 0) {
                return false;
            }
            if (act == 2) {
                destroy = true;
            }
        }
        if (!silent) {
            this.report(info);
        }
        if (destroy) {
            this.stopApplet();
            return true;
        }
        if (this.m_doNotifyDialog && !this.m_doAllowDialog) {
            destroy = this.showOKDialog(info);
        }
        if (!destroy) {
            this.m_ses.incrOffenceCount();
            if (this.m_maxOffenses > 0 && this.m_ses.getOffenceCount() >= this.m_maxOffenses) {
                destroy = true;
            }
        }
        if (!destroy) {
            throw this.makeSecurityException(info);
        }
        this.stopApplet();
        return true;
    }

    private void stopApplet() {
        this.m_ses.setStatus(1);
        this.m_ses.closeAllActiveWindows();
        this.m_ses.closeAllOpenDialogs();
        this.stopApplets();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            this.m_ses.stopAllActiveThreads();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new AppletTrapStopError(this.m_ses.getMsg("instr.action.policy_stop_error"));
    }

    private void stopApplets() {
        Enumeration iter = this.m_ses.getApplets();
        String msg = this.m_ses.getMsg("instr.msg.dialog.applet_stopped");
        while (iter.hasMoreElements()) {
            Applet applet = (Applet)iter.nextElement();
            if (this.m_ses.isStoppedApplet(applet)) continue;
            ClearAppletThread cat = new ClearAppletThread(this.m_ses, applet, msg, this.m_noUserInteraction);
            cat.start();
            this.m_ses.setAppletStopped(applet);
        }
    }

    private int showAllowDialog(String info) {
        Object[] param = new Object[]{info};
        String msg = MessageFormat.format(this.m_ses.getMsg("instr.msg.dialog.action_warning_start"), param);
        AllowDialog allow = AllowDialog.make(msg, this.m_ses, 1);
        return allow.display();
    }

    private boolean showOKDialog(String info) {
        Object[] param = new Object[]{info};
        String msg = MessageFormat.format(this.m_ses.getMsg("instr.msg.dialog.action_warning_start"), param);
        OkDialog d = OkDialog.make(msg, this.m_ses, "instr.msg.dialog.ask_stop_applet", true);
        return d.display();
    }

    private SecurityException makeSecurityException(String info) {
        Object[] param = new Object[]{info};
        String exmsg = MessageFormat.format(this.m_ses.getMsg("instr.action.policy_security_exception"), param);
        return new SecurityException(exmsg);
    }

    private String composeKey(String key) {
        return this.m_prefix == null ? key : this.m_prefix + "." + key;
    }

    private void report(String msg) {
        StringBuffer rpt;
        if (null == this.m_originURI) {
            return;
        }
        String policy = null != this.m_policyName ? this.m_policyName : "unknown";
        try {
            rpt = new StringBuffer();
            rpt.append(REPORT_START_TAG);
            PolicyRuntime.rptAppend(rpt, REPORT_REASON_TAG, msg, false);
            PolicyRuntime.rptAppend(rpt, REPORT_URI_TAG, this.m_originURI, false);
            Enumeration iter = this.m_ses.getApplets();
            while (iter.hasMoreElements()) {
                Applet applet = (Applet)iter.nextElement();
                if (this.m_ses.isStoppedApplet(applet)) continue;
                PolicyRuntime.rptAppend(rpt, REPORT_CLASS_TAG, applet.getClass().getName(), false);
            }
            PolicyRuntime.rptAppend(rpt, REPORT_POLICYNAME_TAG, policy, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        ReportThread rpth = new ReportThread(this.m_originURI, rpt.toString());
        rpth.start();
    }

    private static void rptAppend(StringBuffer rpt, String tag, String val, boolean atEnd) {
        rpt.append(tag);
        String encoded = URLEncoder.encode(val);
        rpt.append(encoded);
        if (!atEnd) {
            rpt.append(REPORT_AMP);
        }
    }

    private static void syserr(String msg) {
        System.err.println(msg);
        System.err.flush();
    }

    public static String invokeStringGetter(Object obj, String className, String method) {
        Object retval = PolicyRuntime.invokeZeroArgMethod(obj, className, method, CLASS_STRING);
        if (null == retval) {
            return null;
        }
        return (String)retval;
    }

    public static Object invokeZeroArgMethod(Object obj, String className, String method, String returnClass) {
        Object retVal;
        if (null == obj) {
            return null;
        }
        Class<?> cl = obj.getClass();
        if (!PolicyRuntime.checkClass(cl, className)) {
            return null;
        }
        Method meth = PolicyRuntime.getMethod(cl, method);
        if (null == meth) {
            return null;
        }
        try {
            retVal = meth.invoke(obj, (Object[])null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        if (!PolicyRuntime.checkClass(retVal, returnClass)) {
            return null;
        }
        return retVal;
    }

    public static Method getMethod(Class cl, String method) {
        if (null == cl) {
            return null;
        }
        try {
            return cl.getMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean checkClass(Object obj, String className) {
        if (null == obj) {
            return false;
        }
        return PolicyRuntime.checkClass(obj.getClass(), className);
    }

    public static boolean checkClass(Class cl, String className) {
        if (null == cl) {
            return false;
        }
        if (cl.getName().equals(className)) {
            return true;
        }
        return PolicyRuntime.checkClass(cl.getSuperclass(), className);
    }

    static abstract class Factory {
        private final String m_ctxKey;

        Factory(String ctxKey) {
            this.m_ctxKey = ctxKey;
        }

        public String getCtxKey() {
            return this.m_ctxKey;
        }

        abstract PolicyRuntime make(Session var1);
    }

    private static class ReportThread
    extends Thread {
        private final String m_infoStr;
        private final String m_originURI;

        private ReportThread(String originURI, String infoStr) {
            this.m_originURI = originURI;
            this.m_infoStr = infoStr;
        }

        public void run() {
            if (null == this.m_originURI) {
                System.err.println("Origin URI not available - cannot send report");
                return;
            }
            try {
                URL url = new URL(this.m_originURI + PolicyRuntime.RUNTIME_URL_NASE + "/" + this.m_infoStr);
                URLConnection urlConn = url.openConnection();
                urlConn.setDoInput(true);
                urlConn.connect();
                InputStream in = urlConn.getInputStream();
                byte[] buf = new byte[1024];
                while (in.read(buf) > 0) {
                }
            }
            catch (Exception e) {
                System.err.println("Error while reporting ...");
                e.printStackTrace();
            }
        }
    }

    private static class ClearAppletThread
    extends Thread {
        private final Session m_ses;
        private final Applet m_applet;
        private final String m_msg;
        private final boolean m_noUserInteraction;

        private ClearAppletThread(Session ses, Applet applet, String msg, boolean noUserInteraction) {
            this.m_ses = ses;
            this.m_applet = applet;
            this.m_msg = msg;
            this.m_noUserInteraction = noUserInteraction;
        }

        public void run() {
            this.m_applet.removeAll();
            this.m_applet.invalidate();
            this.m_applet.setLayout(new BorderLayout());
            if (StubAppletDisplay.useAppletArea(this.m_applet)) {
                this.showInAppletArea();
            } else {
                this.showInDialog();
            }
        }

        private void showInDialog() {
            if (this.m_noUserInteraction) {
                return;
            }
            AlertDialog d = AlertDialog.make(this.m_ses, this.m_msg, "instr.msg.dialog.applet_terminated");
            d.display();
        }

        private void showInAppletArea() {
            TextArea ta = StubAppletDisplay.getTextArea(this.m_msg);
            this.m_applet.add("Center", ta);
            ta.invalidate();
            this.m_applet.validate();
        }
    }
}

