/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.FileIOPolicyRuntime;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.MiscPolicyRuntime;
import com.trend.iwss.jscan.runtime.NetworkPolicyRuntime;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.RuntimeValue;
import com.trend.iwss.jscan.runtime.ThreadPolicyRuntime;
import com.trend.iwss.jscan.runtime.WindowPolicyRuntime;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public final class ReflectionPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime = ReflectionPolicyRuntime.class$("com.trend.iwss.jscan.runtime.ReflectionPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime);
    public static final String NAME = "Reflection";
    public static final String PROP_PREFIX = "reflection";
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set("java/lang/reflect/");
    public static final MethodRefMatcher MATCH_METHOD = MATCHERS.make("java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
    public static final MethodRefMatcher MATCH_CONSTRUCTOR = MATCHERS.make("java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
    private static final Hashtable hash = new Hashtable();
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime;

    private ReflectionPolicyRuntime() {
        super(NAME, PROP_PREFIX, null);
    }

    public static void preFilter(CallContext ctx) {
        try {
            String className = ReflectionPolicyRuntime.getClassName(ctx);
            if (null == className) {
                return;
            }
            CallContext newCtx = ReflectionPolicyRuntime.getReflectContext(ctx);
            if (null == newCtx) {
                return;
            }
            hash.put(ctx, newCtx);
            if (FileIOPolicyRuntime.MATCHERS.matchClass(className)) {
                FileIOPolicyRuntime.preFilter(newCtx);
            } else if (NetworkPolicyRuntime.MATCHERS.matchClass(className)) {
                NetworkPolicyRuntime.preFilter(newCtx);
            } else if (ThreadPolicyRuntime.MATCHERS.matchClass(className)) {
                ThreadPolicyRuntime.preFilter(newCtx);
            } else if (WindowPolicyRuntime.MATCHERS.matchClass(className)) {
                WindowPolicyRuntime.preFilter(newCtx);
            } else if (MiscPolicyRuntime.MATCHERS.matchClass(className)) {
                MiscPolicyRuntime.preFilter(newCtx);
            } else if (MATCHERS.match(newCtx)) {
                ReflectionPolicyRuntime.preFilter(newCtx);
            }
        }
        catch (Exception ex) {
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            ex.printStackTrace();
        }
    }

    public static void postFilter(CallContext ctx) {
        try {
            String className = ReflectionPolicyRuntime.getClassName(ctx);
            if (null == className) {
                return;
            }
            CallContext newCtx = (CallContext)hash.get(ctx);
            if (newCtx == null) {
                return;
            }
            hash.remove(ctx);
            if (ctx.getTarget() instanceof Method) {
                newCtx.setResult(ReflectionPolicyRuntime.toRuntimeValue(ctx.getResult().getObjectValue(), ((Method)ctx.getTarget()).getReturnType()));
            } else if (ctx.getTarget() instanceof Constructor) {
                newCtx.setTarget(ctx.getResult().getObjectValue());
            } else {
                return;
            }
            if (FileIOPolicyRuntime.MATCHERS.matchClass(className)) {
                FileIOPolicyRuntime.preFilter(newCtx);
            } else if (NetworkPolicyRuntime.MATCHERS.matchClass(className)) {
                NetworkPolicyRuntime.preFilter(newCtx);
            } else if (ThreadPolicyRuntime.MATCHERS.matchClass(className)) {
                ThreadPolicyRuntime.preFilter(newCtx);
            } else if (WindowPolicyRuntime.MATCHERS.matchClass(className)) {
                WindowPolicyRuntime.preFilter(newCtx);
            } else if (MiscPolicyRuntime.MATCHERS.matchClass(className)) {
                MiscPolicyRuntime.preFilter(newCtx);
            } else if (MATCHERS.match(newCtx)) {
                ReflectionPolicyRuntime.postFilter(newCtx);
            }
        }
        catch (Exception ex) {
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            ex.printStackTrace();
        }
    }

    void _preFilter(CallContext ctx) {
    }

    void _postFilter(CallContext ctx) {
    }

    private static CallContext getReflectContext(CallContext ctx) {
        if (ctx.getTarget() instanceof Method) {
            return ReflectionPolicyRuntime.transformMethodContext(ctx);
        }
        if (ctx.getTarget() instanceof Constructor) {
            return ReflectionPolicyRuntime.transformConstructorContext(ctx);
        }
        return null;
    }

    private static String getClassName(CallContext ctx) {
        Object target = ctx.getTarget();
        if (target instanceof Method) {
            return ((Method)target).getDeclaringClass().getName();
        }
        if (target instanceof Constructor) {
            return ((Constructor)target).getDeclaringClass().getName();
        }
        return null;
    }

    private static CallContext transformMethodContext(CallContext ctx) {
        Method m = (Method)ctx.getTarget();
        int opcode = Modifier.isStatic(m.getModifiers()) ? 184 : 182;
        Class[] params = m.getParameterTypes();
        String desc = ReflectionPolicyRuntime.makeParamString(params, ReflectionPolicyRuntime.classToDesc(m.getReturnType()));
        CallContext ret = new CallContext(opcode, m.getDeclaringClass().getName().replace('.', '/'), m.getName(), desc, ctx.getThisObject());
        ret.setTarget(ctx.getArg(0).getObjectValue());
        Object[] args = (Object[])ctx.getArg(1).getObjectValue();
        ReflectionPolicyRuntime.addArgsToCtx(ctx, args, params);
        return ret;
    }

    private static CallContext transformConstructorContext(CallContext ctx) {
        Constructor c = (Constructor)ctx.getTarget();
        int opcode = 183;
        Class[] params = c.getParameterTypes();
        String desc = ReflectionPolicyRuntime.makeParamString(params, "V");
        CallContext ret = new CallContext(opcode, c.getDeclaringClass().getName().replace('.', '/'), "<init>", desc, ctx.getThisObject());
        ret.setTarget(null);
        Object[] args = (Object[])ctx.getArg(0).getObjectValue();
        ReflectionPolicyRuntime.addArgsToCtx(ctx, args, params);
        return ret;
    }

    private static void addArgsToCtx(CallContext ctx, Object[] args, Class[] params) {
        if (args == null) {
            return;
        }
        if (params == null) {
            return;
        }
        for (int i = args.length - 1; i >= 0; --i) {
            if (i >= params.length) continue;
            ctx.addArg(ReflectionPolicyRuntime.toRuntimeValue(args[i], params[i]));
        }
    }

    private static String makeParamString(Class[] params, String returnType) {
        String desc = "(";
        if (null != params) {
            for (int ii = 0; ii < params.length; ++ii) {
                desc = desc + ReflectionPolicyRuntime.classToDesc(params[ii]);
            }
        }
        return desc + ")" + returnType;
    }

    private static RuntimeValue toRuntimeValue(Object obj, Class type) {
        RuntimeValue ret;
        try {
            ret = type == Boolean.TYPE ? new RuntimeValue((Boolean)obj) : (type == Character.TYPE ? new RuntimeValue(((Character)obj).charValue()) : (type == Byte.TYPE ? new RuntimeValue((Byte)obj) : (type == Short.TYPE ? new RuntimeValue((Short)obj) : (type == Integer.TYPE ? new RuntimeValue((Integer)obj) : (type == Long.TYPE ? new RuntimeValue((Long)obj) : (type == Float.TYPE ? new RuntimeValue(((Float)obj).floatValue()) : (type == Double.TYPE ? new RuntimeValue((Double)obj) : new RuntimeValue(obj))))))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ret = new RuntimeValue(obj);
        }
        return ret;
    }

    private static String classToDesc(Class type) {
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type.isArray()) {
            return type.getName();
        }
        return "L" + type.getName() + ";";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

