/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;
import java.awt.Window;

public final class WindowPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime = WindowPolicyRuntime.class$("com.trend.iwss.jscan.runtime.WindowPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime);
    public static final String NAME = "Window";
    public static final String PROP_PREFIX = "window";
    public static final Factory FACT = new Factory("Window");
    public static final String CFG_WINDOW_NUM_LIMITED_BOOL = "num_limited";
    public static final String CFG_WINDOW_NUM_MAX_INT = "num_max";
    private static final String[] CLASSES = new String[]{"java/awt/Frame", "java/awt/Dialog", "java/awt/Window", "javax/swing/JFrame", "javax/swing/JDialog", "javax/swing/JWindow"};
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set();
    private static final MethodRefMatcher.Set MATCHERS_SHOW = MATCHERS.makeSet();
    private static final MethodRefMatcher MATCH_SHOW = MATCHERS_SHOW.make(CLASSES, "show");
    private static final MethodRefMatcher MATCH_SETVISIBLE = MATCHERS_SHOW.make(CLASSES, "setVisible");
    private static final MethodRefMatcher.Set MATCHERS_DISPOSE = MATCHERS.makeSet();
    private static final MethodRefMatcher MATCH_DISPOSE = MATCHERS_DISPOSE.make(CLASSES, "dispose");
    private boolean m_isLimited = this.getBoolPolicyProp("num_limited", false);
    private int m_maxWindows = this.getIntPolicyProp("num_max", 0);
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime;

    WindowPolicyRuntime(Session ses) {
        super(NAME, PROP_PREFIX, ses);
    }

    public static void preFilter(CallContext ctx) {
        PolicyRuntime.preFilter(ctx, FACT);
    }

    public static void postFilter(CallContext ctx) {
        PolicyRuntime.postFilter(ctx, FACT);
    }

    void _preFilter(CallContext ctx) {
        if (!this.matchShow(ctx)) {
            return;
        }
        int active = this.m_ses.getActiveWindowsCount();
        if (this.m_isLimited && this.m_maxWindows <= active) {
            this.stopAction("instr.msg.window.limit", "" + this.m_maxWindows);
        }
    }

    void _postFilter(CallContext ctx) {
        if (this.matchDispose(ctx)) {
            this.m_ses.removeActiveWindow((Window)ctx.getTarget());
        } else if (this.matchShow(ctx)) {
            this.m_ses.addActiveWindow((Window)ctx.getTarget());
        }
    }

    private boolean matchShow(CallContext ctx) {
        if (MATCH_SHOW.match(ctx)) {
            return true;
        }
        if (!MATCH_SETVISIBLE.match(ctx)) {
            return false;
        }
        return ctx.getArg(0).getBooleanValue();
    }

    private boolean matchDispose(CallContext ctx) {
        if (MATCHERS_DISPOSE.match(ctx)) {
            return true;
        }
        if (!MATCH_SETVISIBLE.match(ctx)) {
            return false;
        }
        return !ctx.getArg(0).getBooleanValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String ctxKey) {
            super(ctxKey);
        }

        PolicyRuntime make(Session ses) {
            return new WindowPolicyRuntime(ses);
        }
    }
}

