#!/bin/sh
#
# Mac OS-X compile script 
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
#====================================================================


if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


export GROOT=/opt/gcc-11.2.0/bin
export PATH=$GROOT:$PATH
export SDKROOT=$(xcrun --show-sdk-path)
export FWROOT=/System/Library/Frameworks



# first, create oal.o:
$GROOT/g++ src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Isrc/adabindings/adaOpenAL/OalBinding \
-Isrc/adabindings/adaOpenAL/OalBinding/incoal




$GROOT/gnatmake sokerban -O3  \
-o sokerban_osx \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/src/adautils \
-I$PWD/src/adabindings/gl \
-I$PWD/src/adabindings/glfwada \
-I$PWD/src/adabindings/AdaPngLib \
-I$PWD/src/adabindings/adaOpenAL \
-I$PWD/src/adabindings/adaOpenAL/OalBinding \
-largs \
oal.o \
$PWD/libs/osx/libglfw3.a \
-L$SDKROOT/usr/lib \
-lm -lz -lstdc++ \
\
-F$FWROOT \
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-framework OpenAL \
-pthread



# -- Copyright (C) 2022  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

