

--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


-- World Cup Sokerban

-- Soccer-themed Sokoban, SDL2 version;  Retina compatible.


-------------------------------------------------------------------------------


with snd4ada;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;

----------------------------------------------------------------

with glfw3; use glfw3;
with zoomwheel;

----------------------------------------------------------------

with matutils;
--with utex;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;
with ada.numerics.generic_elementary_functions;

----------------------------------------------------------------


with shader;  use shader;

with roomobj;
with rectobj;
with pictobj;
with cyl2obj;



with text_io;
with pngloader;
with matutils;

with ada.calendar;

with ada.strings.fixed;

----------------------------------------------------------------


package gametypes is

use text_io;
use pngloader;
use matutils;

use interfaces.c;
use interfaces.c.strings;
use glext;
use glext.pointers;
use glext.binding;
use gl;
use gl.binding;
use gl.pointers;


	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;


use Ada.Strings.Unbounded;
use Ada.Strings.Unbounded.Text_IO;


	onepi : constant float     := 3.14159_26535_89793;
	halfpi : constant float    := onepi/2.0;
	fourthpi : constant float  := onepi/4.0;
	twopi : constant float     := onepi*2.0;
	deg2rad : constant float   := onepi/180.0;
	rad2deg : constant float   := 180.0/onepi;


	vertbuff, uvbuff, elembuff, rgbbuff, vertexarrayid : gluint;



male: boolean := true;
playedonce : boolean := false;
normalMode : boolean := true;
sptime,playSecs : float := 0.0;


-- begin barrel data ----------------------------------------------------
	nbarrels : integer := 0;
	mxbarrels : constant integer := 512; --(see sas8 #49)
	rolling : array(1..mxbarrels) of boolean := (others=>false);
	barrel : array(1..mxbarrels) of cyl2obj.ball;   --variable
	barloc : array(1..mxbarrels) of pictobj.pictangle; --fixed pos
	myfloor : rectobj.rectangle;
	mypusher  : pictobj.pictangle;
	barrow, barcol, recrow, reccol : array(1..mxbarrels) of integer;

	dx, dz, barrad : float;
	smallball : constant float := 0.9; --shrink drawn-size of soccer balls
	-- smaller than 0.8 obscures valid ball locations
	-- bigger than 0.9 makes ball obscure nets

-- end barrel data ----------------------------------------------------

	xsmallman : constant float := 0.6; --width
	zsmallman : constant float := 0.8; --height
	-- shrink the drawn size of pusher man


	winner, userexit, help, details : boolean := false;

	maxrow, maxcol : constant integer := 50;
	maxsize : constant integer := maxrow*maxcol;

	celloc : array(1..maxrow,1..maxcol) of pictobj.pictangle; --fixed


	maxmoves : constant integer := 2000;

	wall, rcpt, barl : array(1..maxrow,1..maxcol) of boolean;
	barptr : array(1..maxrow,1..maxcol) of integer;

	type rubyarray is array(1..mxbarrels,1..maxmoves) of integer;
	type rubyref is access rubyarray;
	barrowsave, barcolsave : rubyref;




	prset, pcset : integer;
	pointset : boolean := false;
	barrowset, barcolset : array(1..mxbarrels) of integer;

	prsave, pcsave : array(1..maxmoves) of integer;
	nrows, ncols, pr,pc, oldpr,oldpc, oldbr,oldbc,
		newbr,newbc : integer;
	upc,upr : float;

	haveSolution: integer := 0;
	waiting: boolean := false;
	failureNotice: boolean := true;

	solutionPath,
	infilname : unbounded_string;

	--pt,
	maxlevel, step, npush : integer;

	apo: array(1..maxrow,1..maxcol) of pictobj.pictangle;
	ppo: pictobj.pictangle;


	type vec3 is array(1..3) of float;





	--eyepos : vec3 := (0.0, 2.0, -0.5);
	--ceyepos : constant vec3 := (0.0, 2.0, -0.8);
	ceyepos : constant vec3 := (0.0, float(zoomwheel.zdefault), -0.8);
	eyepos : vec3 := ceyepos;

	focus  : vec3 := (0.0, -1.0, 0.0);
	clook   : constant vec3 := -- focus - eyepos;
		( focus(1)-eyepos(1), focus(2)-eyepos(2), focus(3)-eyepos(3) );

	cvertang : constant float := fmath.arctan( clook(2), clook(3) );
	vertang : float := cvertang;
	choriang : constant float := 0.0;

-- NOTE:
-- looking straight toward +Z we have:
-- +Y is upward
-- +X is leftward




	mainWin :  access GLFWwindow;


	fcol,frow : float;

	Nwid,Nhit, Wwid,Whit, Fwid, Fhit : aliased interfaces.c.int;

	--ret : interfaces.c.int;
	--numkeys : aliased glint;


	-- enforce minimum time between reaction to keys:
	atime, ktime, akeytime, keytime : float := 0.0;
	arrowdwell : constant float := 0.2; --UDLR arrow keys
	dwell : constant float := 0.4; -- all other keys




	flev, fnum : integer := 0;
	savename : constant string := "./data/resume.txt";

	fmax : integer;
	maxfmax : constant integer := 90;
	mylev,mxlev : array(1..maxfmax) of integer;
	gamefiles, shortname : array(1..maxfmax) of unbounded_string;









	nontexshadid, pgmtexshadid,
	barloc_texid,
	room_texid, floor_texid, wall_texid,
	gray_texid,

	mpush_texid, mpushEa_texid, mpushWe_texid,
	fpush_texid, fpushEa_texid, fpushWe_texid
	: gluint := 0;

	ntmatrixid, matrixid, uniftex : glint;

	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);





currentTime, waitSec, elapsedSec : float;

szfont : integer;
left: float;

onGoal : boolean;
rmo : roomobj.room;
j1,j2,j3,j4,j5,j6 : float;
barreltime, tt, barangle : float;
midbc,midbr, xx,yy,zz : float;
barlv, axis : vec3;
xaxis : constant vec3 := (1.0, 0.0, 0.0);
zaxis : constant vec3 := (0.0, 0.0, 1.0);

tfile : text_io.file_type;


ddxx : float := 0.0; --col correction for centroid
ddzz : float := 0.0; --row correction for centroid

	goal, kick: glint;
profile, flags, major, minor, mtu : glint;

end gametypes;


