separate( sokerban )

procedure getKeyInputs( 
	mainWin : access GLFWwindow;
	Change: out boolean
	) is
--movement requires discrete arrow-key responses.
--But, due to the use of pollevents in "main", we COULD wait until
--receiving a key up to avoid multiple responses to a key press.
--Alternatively, we enforce a keydlay...

	deltaTime,
	nowTime : float;

	zmin : constant gldouble := 0.1;
	zmax : constant gldouble := 10.0;
	solved: boolean;
	ch: character;


	puzz: emutils.puzarray;

begin
	change:=true;
	nowTime := float(glfwGetTime);
	deltaTime := nowTime - oldTimeKb;



-- First, we process continuous key-press responses:-----------------

if glfwgetkey( mainWin, glfw_key_escape ) = Glfw_Press then
		userexit:=true;
		return;

elsif glfwgetkey( mainWin, glfw_key_q ) = Glfw_Press then
		userexit:=true;
		return;

--zoom in : Closer
elsif glfwgetkey( mainWin, glfw_key_c ) = Glfw_Press then
			zoomwheel.zdist:=0.99*zoomwheel.zdist;
			if zoomwheel.zdist<zmin then zoomwheel.zdist:=zmin; end if;
			eyepos(2):=float(zoomwheel.zdist);
		return;

--Further : zoom out
elsif glfwgetkey( mainWin, glfw_key_f ) = Glfw_Press then
			zoomwheel.zdist:=1.01*zoomwheel.zdist;
			if zoomwheel.zdist>zmax then zoomwheel.zdist:=zmax; end if;
			eyepos(2):=float(zoomwheel.zdist);
		return;



-- Second, we process discrete key-press events -----------------------

elsif deltaTime > keydlay then 


	if glfwgetkey( mainWin, glfw_key_o ) = Glfw_Press then
		zoomwheel.zdist := zoomwheel.zdefault;
		eyepos(2) := float(zoomwheel.zdist);
		oldTimeKb := nowTime;

	elsif 
		glfwgetkey( mainWin, glfw_key_up ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_w ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_i ) = Glfw_Press 
	then
		moveup;
		haveSolution:=0;
		oldTimeKb := nowTime;

	elsif 
		glfwgetkey( mainWin, glfw_key_down ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_s ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_k ) = Glfw_Press 
	then
		movedown;
		haveSolution:=0;
		oldTimeKb := nowTime;

	elsif 
		glfwgetkey( mainWin, glfw_key_left ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_a ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_j ) = Glfw_Press 
	then
		moveleft;
		haveSolution:=0;
		oldTimeKb := nowTime;

	elsif 
		glfwgetkey( mainWin, glfw_key_right ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_d ) = Glfw_Press 
		or
		glfwgetkey( mainWin, glfw_key_l ) = Glfw_Press 
	then
		moveright;
		haveSolution:=0;
		oldTimeKb := nowTime;









	-- Boy
	elsif glfwgetkey( mainWin, glfw_key_b ) = Glfw_Press then
		male:=true;
		oldTimeKb := nowTime;

	-- Girl
	elsif glfwgetkey( mainWin, glfw_key_g ) = Glfw_Press then
		male:=false;
		oldTimeKb := nowTime;





	elsif glfwgetkey( mainWin, glfw_key_h ) = Glfw_Press then
		help:=not help;
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_x ) = Glfw_Press then
		details:=not details;
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_u ) = Glfw_Press then
		undo;
		oldTimeKb := nowTime;
		haveSolution:=0;


	-- Restart original puzzle
	elsif glfwgetkey( mainWin, glfw_key_1 ) = Glfw_Press then
		pointset:=false;
		restart;
		oldTimeKb := nowTime;
		haveSolution:=0;

	-- Reset@setpoint
	elsif glfwgetkey( mainWin, glfw_key_r ) = Glfw_Press then
		restart;
		oldTimeKb := nowTime;
		haveSolution:=0;


	elsif glfwgetkey( mainWin, glfw_key_z ) = Glfw_Press then
		setpoint;
		sptime:=nowTime;
		oldTimeKb := nowTime;

	-- Next level
	elsif 
		(glfwgetkey( mainWin, glfw_key_n ) = Glfw_Press) 
	then

		if flev<mxlev(fnum) then
			flev:=flev+1;
		else
			flev:=1;
		end if;
		mylev(fnum):=flev;
		pointset:=false;
		restart;
		haveSolution:=0;
		oldTimeKb := nowTime;


	-- Previous level
	elsif 
		(glfwgetkey( mainWin, glfw_key_p ) = Glfw_Press) 
	then

		if flev>1 then
			flev:=flev-1;
		else
			flev:=mxlev(fnum);
		end if;
		mylev(fnum):=flev;
		pointset:=false;
		restart;
		haveSolution:=0;
		oldTimeKb := nowTime;

------------------------------------------------------------------------

	elsif 
		(glfwgetkey( mainWin, glfw_key_right_shift ) = Glfw_Press)
	then

		if normalMode then
			--mylev(fnum):=flev;
			fnum := 1 + fnum mod fmax;
			flev := mylev(fnum);
			infilname := gamefiles(fnum);
			pointset:=false;
			restart;
			keytime:=currentTime;
			haveSolution:=0;
		end if;

		oldTimeKb := nowTime;


	elsif glfwgetkey( mainWin, glfw_key_left_shift ) = Glfw_Press then

		if normalMode then
			--mylev(fnum):=flev;
			fnum := fnum-1;
			if fnum<1 then
				fnum:=fmax;
			end if;
			flev := mylev(fnum);
			infilname := gamefiles(fnum);
			pointset:=false;
			restart;
			keytime:=currentTime;
			haveSolution:=0;
		end if;

		oldTimeKb := nowTime;




	elsif glfwgetkey( mainWin, glfw_key_0 ) = Glfw_Press then
		oldTimeKb := nowTime;
		vertang:=cvertang;
		eyepos := ceyepos;





	elsif glfwgetkey( mainWin, glfw_key_backslash ) = Glfw_Press then
		oldTimeKb := nowTime;
		vertAng := vertAng + 0.002;




	elsif glfwgetkey( mainWin, glfw_key_slash ) = Glfw_Press then
		oldTimeKb := nowTime;
		vertAng := vertAng - 0.002;


------------- begin 3 solvers ---------------------------------------------------

	--3rd solver method: ibox
	elsif glfwgetkey( mainWin, glfw_key_comma ) = Glfw_Press then
		oldTimeKb := nowTime;

		if not winner then

				if 
					haveSolution>0
				then
					ch:=ada.characters.handling.to_upper( element(solutionPath,1) );
					delete(solutionPath,1,1);
					haveSolution:=length(solutionPath);
					akeytime:=currentTime;

					if ch='U' then
						moveup;
					elsif ch='D' then
						movedown;
					elsif ch='L' then
						moveleft;
					elsif ch='R' then
						moveright;
					else
						--error...should not occur
						haveSolution:=0;
					end if;

				else

					xdump2arr(puzz);
					keytime:=currentTime;

	---------------- begin solver wait -------------------------------------
					glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
					waiting:=true;
					failureNotice:=false;
					Draw; -- main drawing here
						glflush;
						glfwSwapBuffers(mainWin);

					set_unbounded_string(solutionPath, "");

					solved :=
						emsolver.ibox(timeout, puzz, solutionPath);
					haveSolution := length(solutionPath);
					waiting:=false;

					if (haveSolution=0) and not failureNotice then
						failureNotice:=true;
						Draw;
						wtex.print2d("Timed Soln NOT found",0.10,0.98,25);
						glflush;
						glfwSwapBuffers(mainWin);
						delay(2.0);
					end if;

	---------------- end solver wait -------------------------------------

				end if;


		end if; --not winner







	--2nd solver: box4 (hbox4)
	elsif glfwgetkey( mainWin, glfw_key_period ) = Glfw_Press then
		oldTimeKb := nowTime;

		if not winner then

				if 
					haveSolution>0
				then
					ch:=ada.characters.handling.to_upper( element(solutionPath,1) );
					delete(solutionPath,1,1);
					haveSolution:=length(solutionPath);
					akeytime:=currentTime;

					if ch='U' then
						moveup;
					elsif ch='D' then
						movedown;
					elsif ch='L' then
						moveleft;
					elsif ch='R' then
						moveright;
					else
						--error...should not occur
						haveSolution:=0;
					end if;

				else

					xdump2arr(puzz);
					keytime:=currentTime;

	---------------- begin solver wait -------------------------------------
					glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
					waiting:=true;
					failureNotice:=false;
					Draw; -- main drawing here
						glflush;
						glfwSwapBuffers(mainWin);

					set_unbounded_string(solutionPath, "");

					solved :=
						emsolver.box4(timeout, puzz, solutionPath);
					haveSolution := length(solutionPath);
					waiting:=false;

					if (haveSolution=0) and not failureNotice then
						failureNotice:=true;
						Draw;
						wtex.print2d("Timed Soln NOT found",0.10,0.98,25);
						glflush;
						glfwSwapBuffers(mainWin);
						delay(2.0);
					end if;

	---------------- end solver wait -------------------------------------

				end if;


		end if; --not winner




	--1st solver method: puller
	elsif glfwgetkey( mainWin, glfw_key_equal ) = Glfw_Press then
		oldTimeKb := nowTime;

		if not winner then

				if 
					haveSolution>0
				then
					ch:=ada.characters.handling.to_upper( element(solutionPath,1) );
					delete(solutionPath,1,1);
					haveSolution:=length(solutionPath);
					akeytime:=currentTime;

					if ch='U' then
						moveup;
					elsif ch='D' then
						movedown;
					elsif ch='L' then
						moveleft;
					elsif ch='R' then
						moveright;
					else
						--error...should not occur
						haveSolution:=0;
					end if;

				else

					xdump2arr(puzz);
					keytime:=currentTime;

	---------------- begin solver wait -------------------------------------
					glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
					waiting:=true;
					failureNotice:=false;
					Draw; -- main drawing here
						glflush;
						glfwSwapBuffers(mainWin);

					set_unbounded_string(solutionPath, "");

					solved :=
						emsolver.puller(timeout, puzz, solutionPath);
					haveSolution := length(solutionPath);
					waiting:=false;

					if (haveSolution=0) and not failureNotice then
						failureNotice:=true;
						Draw;
						wtex.print2d("Timed Soln NOT found",0.10,0.98,25);
						glflush;
						glfwSwapBuffers(mainWin);
						delay(2.0);
					end if;

	---------------- end solver wait -------------------------------------

				end if;


		end if; --not winner

------------- end 3 solvers ---------------------------------------------------


	else
		change:=false;

	end if;


end if;

end getKeyInputs;




