separate(sokerban)


procedure getmouseclick( 
	mainWin : access GLFWwindow;
	wid, hit: interfaces.c.int
	) is

	msr,msl: glint;
	nowTime: float := float(glfwGetTime);
	dt : float := nowTime - mptime;
	xpos, ypos : aliased gldouble;
	nn, br,bc: integer;

	fmx,fmy,mindist: float := 1000.0;

	--zndc,zn,
	xndc, yndc, xn,yn, dist : float;
	v4, vcc : vec4;
	found: boolean := false;

	subtype ushort is emutils.ushort;
	function lt( a, b: ushort ) return boolean is
		use emutils;
	begin
		if a<b then return true; else return false; end if;
	end lt;

	--use emutils;
	ubr,ubc,ur,uc: ushort;

	dx,dz,ddxx,ddzz: float := 0.0;
	maxrc: integer;
begin

	if ncols > nrows then
		ddzz := 0.5*float(ncols-nrows);
		maxrc:=ncols;
	elsif nrows > ncols then
		ddxx := 0.5*float(nrows-ncols);
		maxrc:=nrows;
	end if;
	dx := 1.0/float(maxrc);
	dz:=dx;


	if dt>pickdwell then

		msr := glfwGetMouseButton(mainWin, glfw_mouse_button_2);
		msl := glfwGetMouseButton(mainWin, glfw_mouse_button_1);
		-- msl,msr: glint;


		if msr=glfw_press then
			mptime:=nowtime;
			hilite:=false;

		elsif msl=glfw_press	then
			mptime:=nowtime;



--put(float'image(dt));
--put(" ?>? ");
--put(float'image(pickdwell));
--new_line;


			glfwgetcursorpos(mainWin,xpos'access,ypos'access);

			fmx := 0.0 + float(xpos/ gldouble(wid));
			fmy := 1.0 - float(ypos/ gldouble(hit));


--NEED a 3d pick here...just picking closest cell to clickPos
			for r in 1..nrows loop
			for c in 1..ncols loop
				xx:=(-0.5+ddxx+float(c))*dx; -- in [0..1]
				zz:=(-0.5+ddzz+float(r))*dz; -- in [0..1]
				yy:=-0.95; --xx,yy,zz = centroid of cell @ r,c

				xx := 1.0-2.0*xx;
				zz := 1.0-2.0*zz;

				v4 := (xx,yy,zz,1.0);
				matXvec( mvp, v4, vcc );

				xndc:=vcc(1)/vcc(4); --// ndc in [-1..1]
				yndc:=vcc(2)/vcc(4); --// 
				--zndc:=vcc(3)/vcc(4); --// bigger zndc if further away

				xn:=(1.0+xndc)/2.0;
				yn:=(1.0+yndc)/2.0;
				--zn:=(1.0+zndc)/2.0;

				dist := (fmx-xn)*(fmx-xn)+(fmy-yn)*(fmy-yn);
				if( dist < mindist ) then
					found:=true;
					mindist:=dist;
					br:=r; bc:=c;
				end if;
	
			end loop;
			end loop;


--	put(" picked: ");
--	put(integer'image(br));
--	put(integer'image(bc)); put(" : ");
--	put(integer'image(nrows));
--	put(integer'image(ncols));
--	new_line;


			--highlight possible destinations
			mask:=( others=>(others=>false) );
			nn:=0;
			if barl(br,bc)	then
			--highlight valid locations this box can reach

				ubr:=ushort(br); ubc:=ushort(bc);

				for r in 1..gametypes.nrows loop
				for c in 1..gametypes.ncols loop
					ur:=ushort(r); uc:=ushort(c);
					if lt(emhungarian.getcost(ur,uc,ubr,ubc),255) then
						mask(r,c):=true;
						nn:=nn+1;
					end if;
				end loop;
				end loop;

				hilite:=true;

			elsif rcpt(br,bc) then
			--highlight locations that can come to this goal

				ubr:=ushort(br); ubc:=ushort(bc);

				for r in 1..gametypes.nrows loop
				for c in 1..gametypes.ncols loop
					ur:=ushort(r); uc:=ushort(c);
					if lt(emhungarian.getcost(ubr,ubc,ur,uc),255) then
						mask(r,c):=true;
						nn:=nn+1;
					end if;
				end loop;
				end loop;

				hilite:=true;

			end if;

if hilite then
	put(" picked: ");
	put(integer'image(br));
	put(integer'image(bc)); 
	if barl(br,bc) then
		put(" box");
	elsif rcpt(br,bc) then
		put(" goal");
	end if;
	new_line;
end if;

		end if;

	end if;

end getmouseclick;



