<?php
// $Id: rssc_view_param.php,v 1.5 2006/09/11 07:59:27 ohwada Exp $

// 2006-09-01 K.OHWADA
// add view_format_sanitize_single_feed_obj() : remove view_format_sanitize_feeds()
// add get_get_keywords()
// highlight_keyword

// 2006-07-22 K.OHWADA
// page title

// 2006-07-10 K.OHWADA
// use happy_linux_error happy_linux_post etc

// 2006-06-04 K.OHWADA
// add view_format_sanitize() etc

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_view_param') ) 
{

//=========================================================
// class rssc_view_param
//=========================================================
class rssc_view_param extends happy_linux_error
{
// handler
	var $_feed_handler;	// parent class MUST set, not set in here,

	var $_post;
	var $_system;
	var $_strings;

// input parameter
	var $_feed_order = RSSC_C_ORDER_TEXT_UPDATED;
	var $_feed_start =  0;
	var $_feed_limit = 10;
	var $_flag_sanitize  = false;

// sanitize param
	var $_flag_title_html   = 0;
	var $_flag_content_html = 0;
	var $_max_summary = 250;
	var $_max_title   =   -1;	// unlimited
	var $_max_content =   -1;	// unlimited
	var $_flag_highlight = false;
	var $_keyword_array  = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_view_param()
{
	$this->happy_linux_error();

	$this->_post    =& happy_linux_post::getInstance();
	$this->_system  =& happy_linux_system::getInstance();
	$this->_strings =& happy_linux_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_view_param();
	}

	return $instance;
}

//=========================================================
// public
//=========================================================
//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function setFeedOrder($value)
{
	switch ( intval($value) )
	{
		case RSSC_C_ORDER_INT_PUBLISHED:
			$order = RSSC_C_ORDER_TEXT_PUBLISHED;
			break;

		case RSSC_C_ORDER_INT_UPDATED:
		default:
			$order = RSSC_C_ORDER_TEXT_UPDATED;
			break;
	}

	$this->_feed_order = $order;
}

function setFeedStart($value)
{
	$this->_feed_start = intval($value);
}

function setFeedLimit($value)
{
	$this->_feed_limit = intval($value);
}

function setFlagSanitize($value)
{
	$this->_flag_sanitize = (bool)$value;
}

//---------------------------------------------------------
// feed property
//---------------------------------------------------------
function setFutureDays($value)
{
	$this->_feed_handler->set_future($value);
}

//---------------------------------------------------------
// view sanitize
//---------------------------------------------------------
function &view_format_sanitize($arr)
{
// object
	$obj =& new rssc_xml();
	$obj->set_vars($arr);
	$obj->view_format();
	$this->_set_sanitize_obj( $obj );
	$obj->view_sanitize();
	$data = $obj->get_vars();
	return $data;
}

function &view_sanitize($arr)
{

// object
	$obj =& new rssc_xml();
	$obj->set_vars($arr);
	$this->_set_sanitize_obj( $obj );
	$obj->view_sanitize();
	$data = $obj->get_vars();

	return $data;
}

function &view_format_sanitize_feed_objs( &$feed_objs, $flag_sanitize=true )
{
	$feeds = array();
	if ( is_array($feed_objs) && ( count($feed_objs) > 0 ) )
	{
		foreach ($feed_objs as $obj)
		{
			$feeds[] =& $this->view_format_sanitize_single_feed_obj( $obj, $flag_sanitize );
		}
	}
	return $feeds;
}

function &view_format_sanitize_single_feed_obj( &$feed_obj, $flag_sanitize=true )
{
	$feed = array();
	if ( is_object($feed_obj) )
	{
		$feed =& $this->view_format_sanitize_single_feed( $feed_obj->getVarAll(), $flag_sanitize );
	}
	return $feed;
}

function &view_format_sanitize_single_feed( $feed, $flag_sanitize=true )
{
// object
	$obj =& new rssc_xml();
	$obj->set_single_item( $feed );
	$obj->view_format_single_item();

	if ($flag_sanitize)
	{
		$this->_set_sanitize_obj( $obj );
		$obj->view_sanitize_single_item();
	}

	$feed =& $obj->get_single_item();
	$feed =& $this->_link_handler->add_ltype_single_item($feed);

	return $feed;
}

function _set_sanitize_obj( &$obj )
{
	$obj->set_title_html(   $this->_flag_title_html );
	$obj->set_content_html( $this->_flag_content_html );
	$obj->set_max_title(    $this->_max_title );
	$obj->set_max_content(  $this->_max_content );
	$obj->set_max_summary(  $this->_max_summary );
	$obj->set_flag_highlight( $this->_flag_highlight );
	$obj->set_keyword_array(  $this->_keyword_array );
}

//---------------------------------------------------------
// sanitize property
//---------------------------------------------------------
function set_title_html($value)
{
	$this->_flag_title_html = (bool)$value;
}

function set_content_html($value)
{
	$this->_flag_content_html = (bool)$value;
}

function set_max_title($value)
{
	$this->_max_title = intval($value);
}

function set_max_summary($value)
{
	$this->_max_summary = intval($value);
}

function set_max_content($value)
{
	$this->_max_content = intval($value);
}

function set_highlight($value)
{
	$this->_flag_highlight = (bool)$value;
}

function set_keyword_array($arr)
{
	if ( is_array($arr) && count($arr) )
	{
		$this->_keyword_array = $arr;
	}
}

function set_keyword_by_request()
{
	$this->set_keyword_array( $this->get_get_keyword_array() );
}

function get_keywords_urlencode()
{
	return $this->_strings->urlencode_from_array( $this->_keyword_array );
}

//---------------------------------------------------------
// class post
//---------------------------------------------------------
function get_get_lid()
{
	return $this->_post->get_get_int('lid');
}

function get_get_fid()
{
	return $this->_post->get_get_int('fid');
}

function get_get_start()
{
	return $this->_post->get_get_int('start');
}

function get_get_limit()
{
	return $this->_post->get_get_int('limit');
}

function get_get_mode()
{
	return $this->_post->get_get_int('mode');
}

function get_get_rss_mode()
{
	$mode = $this->_post->get_get_text('mode', 'rss');
	switch ( $mode )
	{
		case 'rdf':
		case 'atom':
			break;

		case 'rss':
		default:
			$mode = 'rss';
			break;
	}
	return $mode;
}

function get_get_keyword_array()
{
	return $this->_post->get_get_keyword_array();
}

//---------------------------------------------------------
// class system
//---------------------------------------------------------
function is_module_admin()
{
	return $this->_system->is_module_admin();
}

// page title
function get_module_name()
{
	return $this->_system->get_module_name();
}

// --- class end ---
}

// === class end ===
}

?>