<?php
// $Id: ping_main.class.php,v 1.1.1.1 2009/03/08 20:14:39 ohwada Exp $

//=========================================================
// weblog updated ping
// 2009-03-08 K.OHWADA
//=========================================================

//=========================================================
// class ping_main
//=========================================================
class ping_main
{
	var $_TIMESTAMP_FILE = 'cache/timestamp.txt';
	var $_LOG_FILE       = 'cache/log.txt';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function ping_main()
{
	// dummy
}

//---------------------------------------------------------
// main
//---------------------------------------------------------
function main()
{
    define('MAGPIE_DIR', BASE_DIR.'/magpierss/');
	define('MAGPIE_OUTPUT_ENCODING', 'UTF-8');
	define('MAGPIE_INPUT_ENCODING',  'UTF-8');
	define('MAGPIE_CACHE_ON', false);

	require_once BASE_DIR.'/snoopy/Snoopy.class.php';
	require_once BASE_DIR.'/class/auto_discovery.class.php';
	require_once BASE_DIR.'/class/weblog_updates.class.php';
	require_once BASE_DIR.'/class/rss_fetch.inc';

	include BASE_DIR.'/config.inc.php';

	$updated    = 0 ;
	$errors     = null;
	$return     = false;
	$flag_mail  = false;
	$flag_print_error = false ;

	$site_name   = $config['site_name'] ;
	$site_url    = $config['site_url'] ;
	$mail_to     = isset($config['mail_to']) ? $config['mail_to'] : null;
	$print_level = isset($config['print_level']) ? intval($config['print_level']) : 0;

// ex) cmd print=1
	$cmd = $this->get_cmd_option();
	if ( isset($cmd['print']) ) {
		$print_level = $cmd['print'];
	}

	if ( $print_level >= 1 ) {
		$flag_print_error = true ;
	}

	$auto_discovery = new auto_discovery;
	$rss_url = $auto_discovery->discover( $site_url );
	if ( empty($rss_url) ) {
		if ( $flag_print_error ) {
			echo $this->build_errors( $auto_discovery->get_erros() );
		}
		return false;
	}

	$rss = fetch_rss( $rss_url );

	$site_title = $rss->channel['title'];
	if ( isset($rss->items[0]['pubdate']) ) {
		$pubdate = $rss->items[0]['pubdate'];
		$updated = $this->get_unixtime_rfc822( $pubdate );

// netcommons's journal has no hour/min/sec, always 00:00:00
// plus 24 hours
		if ( strpos( '00:00:00', $pubdate ) !== false ) {
			$updated += 86400;
		}
	}

	$param = $config;
	$param['updated_time']   = $updated ;
	$param['print_level']    = $print_level ;
	$param['timestamp_file'] = BASE_DIR.'/'.$this->_TIMESTAMP_FILE ;
	$param['log_file']       = BASE_DIR.'/'.$this->_LOG_FILE ;
	if ( empty($site_name) ) {
		$param['site_name'] = $site_title ;
	}

	$weblog_updates = new weblog_updates;
	$ret = $weblog_updates->send_pings_with_check_time( $param );
	if ( $ret == 1 ) {
		$flag_mail = true;
		$msg = $site_url."\n success \n";
		$return = true;

	} elseif ( $ret == -1 ) {
		$errors = $weblog_updates->get_errors();
		$flag_mail = true;
		$msg = "fail \n";

	} else {
		$msg = "no action \n";
		$return = true;
	}

	if ( $flag_mail && $mail_to ) {
		$mail_msg  = $msg;
		$mail_msg .= $this->build_errors( $errors );
		$this->send_mail( $mail_to, $mail_msg );
	}

	if ( $flag_print_error ) {
		echo $msg ;
	}

	return $return;
}

//--------------------------------------------------------
// command
// x=y  =>  $a[x]=y
// z    =>  $a[x]=true
//--------------------------------------------------------
function get_cmd_option()
{
	$arr = array();
	if ( $_SERVER['argc'] > 1 ) {
		for( $i=1; $i<$_SERVER['argc']; $i++ )
		{
			if ( preg_match('/(.*)=(.*)/', $_SERVER['argv'][$i], $matches) ) {
				$arr[ $matches[1] ] = $matches[2];
			} elseif ( preg_match('/(.*)/', $_SERVER['argv'][$i], $matches) ) {
				$arr[ $matches[1] ] = true;
			}
		}
	}
	return $arr;
}

//--------------------------------------------------------
// get unixtime from RFC822
//--------------------------------------------------------
function get_unixtime_rfc822( $date )
{
	$time = strtotime($date);

// maybe undefined time zone
	if ( $time == -1 ) {

// retry after delete time zone
		$date = preg_replace("/ [a-zA-Z]{3,}$/", '', $date);
		$time = strtotime( $date );
	}

// set 0 if give up
	$time = intval($time);
	if ( $time < 0 ) {
		 $time = 0;
	}

	return $time;
}

//--------------------------------------------------------
// mail
//--------------------------------------------------------
function send_mail( $mail_to, $msg )
{
	$subject = 'weblog_updates_ping';
	return mail( $mail_to, $subject, $msg );
}

//--------------------------------------------------------
// error
//--------------------------------------------------------
function build_errors( $errors )
{
	if ( !is_array($errors) ) {
		return $errors;
	}

	$str = '';
	foreach ( $errors as $msg ) {
		$str .= $msg."\n";
	}
	return $str;
}

// --- class end ---
}

?>