<?php
// $Id: exauth.class.php,v 1.1.1.1 2010/08/30 12:51:59 ohwada Exp $

//================================================================
// Twitter Module
// 2010-08-01 K.OHWADA
//================================================================
class twitter_exauth
{
	var $_db = null;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_EXAUTH_TYPE = 'twitter';

//---------------------------------------------------------
// 󥹥ȥ饯
//---------------------------------------------------------
function twitter_exauth()
{
	$this->_db =& Database::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new twitter_exauth();
	}
	return $instance;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

//---------------------------------------------------------
// exauth_id 
//---------------------------------------------------------
function get_flag_exauth_id( $uid )
{
	$flag_exauth_id = false;
	$ret = $this->get_exauth_id_param( $uid );
	if ( $ret ) {
		return true;
	}
	return false;
}

function get_exauth_id( $uid )
{
	$param = $this->get_exauth_id_param( $uid );
	if ( !isset( $param['exauth_id'] ) ) {
		return false;
	}
	return $param['exauth_id'];
}

function get_exauth_id_param( $uid )
{
	$sql =
		"SELECT " .
		"*" .
		" FROM " .
		$this->_db->prefix('exauth_id') .
		" WHERE " . "`exauth`=" . $this->_db->quoteString($this->_EXAUTH_TYPE) .
		' AND ' . '`uid`=' . intval($uid);
	$result = $this->_db->query($sql);
	if ( !$result ) {
		return false;
	}
	$numrows = $this->_db->getRowsNum($result);
	if ( $numrows != 1 ) {
		return false;
	}
	$ret = $this->_db->fetchArray($result);
	return $ret;
}

//---------------------------------------------------------
// user_token 
//---------------------------------------------------------
function get_user_token( $uid )
{
	$token  = null ;
	$secret = null ;

	$param = $this->get_exauth_plugin_user_value( $uid );
	if ( isset( $param['twitter_token'] ) ) {
		$token  = $param['twitter_token'] ;
		$secret = $param['twitter_secret'] ;
	}
	return array( $token, $secret );
}

function get_exauth_plugin_user_value( $uid )
{
	$arr = array();
       $sql =
       	"SELECT *" .
		" FROM " . $this->_db->prefix('exauth_plugin_user_value') .
        " WHERE " . "`uid`=" . intval($uid);
        " AND `exauth`=".$this->_db->quoteString($this->_EXAUTH_TYPE);

	$result = $this->_db->query($sql);
    if ( !$result ) {
		return false;
	}
    while ($line = $this->_db->fetchArray($result)) {
      	$arr[ $line['exauth_conf_name'] ] = $line['exauth_conf_value'] ;
    }
    return $arr;
}

//---------------------------------------------------------
// user_token ꤹ
//---------------------------------------------------------
function set_exauth_plugin_user_value( $uid, $token, $secret )
{
	$usersettings = array(
		'twitter_token'  => $token,
		'twitter_secret' => $secret,
	);

	foreach ( $usersettings as $k => $v )
	{
		$sql =
			"INSERT INTO " .
   			$this->_db->prefix('exauth_plugin_user_value') .
   			" SET " . "`uid`=" . intval($uid) .
   			"," . "`exauth`=" . $this->_db->quoteString($this->_EXAUTH_TYPE) .
   			"," . "`exauth_conf_name`=" . $this->_db->quoteString($k) .
   			"," . "`exauth_conf_value`=" . $this->_db->quoteString($v);
		$result = $this->_db->queryF($sql);
		if ( !$result ) {
			return false;
		}
	}
	return true;
}

// === class end ===

}