<?php
// $Id: index.php,v 1.1.1.1 2010/08/30 12:51:59 ohwada Exp $

//================================================================
// Twitter Module
// 2010-08-01 K.OHWADA
//================================================================

//---------------------------------------------------------
// header
//---------------------------------------------------------
include 'header.php';

//---------------------------------------------------------
// main
//---------------------------------------------------------
$xoops_cube_legacy = false;
if (defined('XOOPS_CUBE_LEGACY')) {
	$xoops_cube_legacy = true;
}

$code = isset($_GET['code']) ? $_GET['code'] : null; 
$msg  = isset($_GET['msg'])  ? $_GET['msg']  : null; 

$message = '';
$error   = '';

if (empty($xoopsUser)) {
	$xoopsOption['template_main'] = 'twitter_please_login.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('show_login_password', true );
	$xoopsTpl->assign('show_login_twitter',  true );
	$xoopsTpl->assign('show_login_openid',   true );
	$xoopsTpl->assign('xoops_cube_legacy',   $xoops_cube_legacy );
	$xoopsTpl->assign('lang_please_login',   _TWITTER_PLEASE_LOGIN );
	$xoopsTpl->assign('lang_login_password', _TWITTER_LOGIN_PASSWORD );
	$xoopsTpl->assign('lang_login_twitter',  _TWITTER_LOGIN_TWITTER );
	$xoopsTpl->assign('lang_login_openid',   _TWITTER_LOGIN_OPENID );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$uid = $xoopsUser->getVar('uid');

$service =& twitter_xoops_service::getInstance();
$exauth  =& $service->get_exauth_Instance();

$ret = $service->init();
if ( !$ret ) {
	$xoopsOption['template_main'] = 'twitter_error.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('error', _TWITTER_ERR_CONSUMER_KEY );
	$xoopsTpl->assign('show_goto_admin', true );
	$xoopsTpl->assign('lang_goto_admin', _TWITTER_GOTO_ADMIN );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$ret = $service->set_user( $uid );
if ( !$ret ) {
	$flag_exauth_id = $exauth->get_flag_exauth_id( $uid );
	$xoopsOption['template_main'] = 'twitter_please_twitter.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('flag_exauth_id',    $flag_exauth_id );
	$xoopsTpl->assign('xoops_cube_legacy', $xoops_cube_legacy );
	$xoopsTpl->assign('lang_please_twitter_id', _TWITTER_PLEASE_TWITTER_ID );
	$xoopsTpl->assign('lang_login_twitter',     _TWITTER_LOGIN_TWITTER );
	$xoopsTpl->assign('lang_err_twitter_id',    _TWITTER_ERR_TWITTER_ID );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

switch ($code)
{
	case 0:
		break;

	case 1:
		$message = _TWITTER_TWEET_SUCCESS;
		break;

	default:
		$error = $service->get_tweet_error( $code, $msg );
		break;
}

$items = $service->get_home_timeline( true );
if ( !$items ) {
	$error = $service->get_error_msg();
}

$token = $xoopsGTicket->issue();

$xoopsOption['template_main'] = 'twitter_index.html';
include XOOPS_ROOT_PATH.'/header.php';

$xoopsTpl->assign('message', $message );
$xoopsTpl->assign('error',   $error );
$xoopsTpl->assign('items',   $items );
$xoopsTpl->assign('token',   $token );
$xoopsTpl->assign('lang_tweet',      _TWITTER_TWEET );
$xoopsTpl->assign('lang_tweet_what', _TWITTER_TWEET_WHAT );
$xoopsTpl->assign('lang_err_tweet_over_140', _TWITTER_ERR_TWEET_OVER_140 );

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// === main end ===

?>