<?php
// $Id: misc.class.php,v 1.1.1.1 2011/03/02 09:42:08 ohwada Exp $

//=========================================================
// Facebook Login
// 2011-03-01 K.OHWADA
//=========================================================

class facebook_misc
{
	var $_NAME_MSG = 'msg';
	var $_TITLE    = 'facebook ログインのデモ (PEAR)';
	var $_LIB_DESC = 'PEAR/Service/facebook';

	var $_email = 'email';
	var $_pass  = 'pass';

	var $_time_now = 0;

function facebook_misc()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new facebook_misc();
	}
	return $instance;
}

function set_email( $v )
{
	$this->_email = $v;
}

function set_pass( $v )
{
	$this->_pass = $v;
}

function get_post_msg()
{
	return $this->get_post_by_key( $this->_NAME_MSG );
}

function get_get_by_key( $key )
{
	$str = isset($_GET[ $key ]) ? $_GET[ $key ] : null;
	return $str;
}

function get_post_by_key( $key )
{
	$str = isset($_POST[ $key ]) ? $_POST[ $key ] : null;
	return $str;
}

function print_login_form()
{
	$body = $this->build_login_form();
	$this->print_html($body);
}

function print_logout( $user, $url, $msg )
{
	$body  = $this->build_login_now( $user, $url );
	$body .= "<br><br>\n";
	$body .= $msg;
	$this->print_html($body);
}

function print_clear( $msg )
{
	$body  = $this->build_clear();
	$body .= "<br><br>\n";
	$body .= $msg;
	$this->print_html($body);
}

function print_post_form( $user, $url, $feeds )
{
	$flag  = $this->get_get_by_key( 'flag' );
	$error = $this->get_get_by_key( 'error' );

	$body  = $this->build_login_now( $user, $url );
	$body .= $this->build_result_msg( $flag, $error );
	$body .= $this->build_post_form();
	$body .= $this->build_feeds( $feeds );
	$this->print_html($body);
}

function build_login_form()
{
	$email = $this->_email;
	$pass  = $this->_pass;

	$str = <<< EOF
<h1> $this->_TITLE </h1>
facebook のアカウントでログインします。<br>
ログイン後は facebook に投稿できます。<br><br>
<a href="?op=login">
[facebook アカウントでログインする]
</a><br>
テスト用のアカウントを用意しています。<br>
メールアドレス $email (あっとを @ に置き換る)<br>
パスワード $pass (全角で表示していますが半角です)
<br><br>
<a href="http://linux.ohwada.jp/modules/smartsection/item.php?itemid=514" target="_blank">解説： facebook ログイン - PEAR</a>
EOF;

	return $str;
}

function build_clear()
{
	$str = <<< EOF
<h1> $this->_TITLE </h1>
<a href="?">[ホーム]</a> 
<a href="?op=clear">[トークン・クリア]</a> 
EOF;

	return $str;
}

function build_login_now( $user, $url )
{
	$href = $url.'#!/';
	$str = <<< EOF
<h1> $this->_TITLE </h1>
<h3>ログイン・ユーザー: <a href="$href" target="_blank">$user</a></h3>
<a href="?">[ホーム]</a> 
<a href="?op=logout">[ログアウト]</a> 
EOF;

	return $str;
}

function build_result_msg( $flag, $error )
{
	$str = '';
	if ( $flag == 1 ) {
		$str .= '<p style="background-color: lightgreen;">投稿 出来ました</p>
'."\n";
	} elseif ( $flag == -1 ) {
		$str .= '<p style="background-color: red;">う～ん！ facebook に嫌われたみたい！</p>'."\n";
        $str .= '<div style="color: red;">';
		$str .= $error;
		$str .= '</div>'."\n";
	}

	return $str;
}

function build_post_form()
{

	$str = <<< EOF
<p>いまどうしてる？</p>
<form action="post.php" method="post" id="msgform">
<textarea name="$this->_NAME_MSG" id="msg" rows="2" cols="70%" onkeypress="return imposemax(this);"></textarea>
<br/><input type="submit" id="submit" value="投稿する"/>
</form>
EOF;

	return $str;
}

function build_feeds( $feeds )
{
	$str  = '<br>'."\n";
	$str .= '<table>'."\n";
	foreach ( $feeds as $feed ) {
		$str .= $this->build_each_feed( $feed );
	}
	$str .= '</table>'."\n";
	return $str;
}

function build_each_feed( $feed )
{
	$a_begin = '';
	$a_end   = '';

	if ( isset( $feed['user_link'] ) ) {
		list( $a_begin, $a_end ) = $this->build_a_href( $feed['user_link'] );
	}

	$str  = '<tr><td valign="top">'."\n";

	if ( isset( $feed['from_id'] ) && $feed['from_id'] ) {
		$str .= $a_begin;
		$str .= '<img src="https://graph.facebook.com/'. $feed['from_id'] .'/picture">'."\n";
		$str .= $a_end;
	}

	$str .= '</td><td valign="top">'."\n";

	if ( isset( $feed['from_name'] ) && $feed['from_name'] ) {
		$str .= $a_begin;
		$str .= $feed['from_name'];
		$str .= $a_end;
		$str .= '<br>'."\n";
	}

	if ( isset( $feed['message_convert'] ) && $feed['message_convert'] ) {
		$str .= $feed['message_convert'];
		$str .= '<br>'."\n";
	}

	if ( isset( $feed['time_elapse'] ) ) {
		$str .= $feed['time_elapse'];
		$str .= ' '."\n";
	}

	if ( isset( $feed['application_link'] ) ) {
		$str .= $feed['application_link'];
	}

	$str .= '</td></tr>'."\n";
	return $str;
}

function build_a_href( $url )
{
	$begin = '';
	$end   = '';
	if ( $url ) {
		$begin = '<a href="'.$url.'" target="_blank">'."\n";
		$end   = '</a>'."\n";
	}
	return array( $begin, $end );
}

function print_html( $body )
{
	echo '<?xml version="1.0" encoding="UTF-8"?>';

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title><?php echo  $this->_TITLE; ?></title>
</head>
<body>
<?php echo $body; ?>
</body>
</html>
<?php
// --- print_tweet_form end --- 
}

// === class end ===
}

?>