<?php
// $Id: misc.class.php,v 1.2 2011/12/16 11:09:28 ohwada Exp $

//=========================================================
// GooglePlus Login with Google API Client
// 2011-12-12 K.OHWADA
//=========================================================

class google_plus_misc
{
	var $_NAME_STATUS = 'status';

	var $_TITLE = 'GooglePlus ログインのデモ (Google API Client)';

function google_plus_misc()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new google_plus_misc();
	}
	return $instance;
}

function get_post_status()
{
	return $this->get_post_by_key( $this->_NAME_STATUS );
}

function get_get_by_key( $key )
{
	$str = isset($_GET[ $key ]) ? $_GET[ $key ] : null;
	return $str;
}

function get_post_by_key( $key )
{
	$str = isset($_POST[ $key ]) ? $_POST[ $key ] : null;
	return $str;
}

function print_login_form()
{
	$body = $this->build_login_form();
	$this->print_html($body);
}

function build_login_form()
{
	$str = <<< EOF
<h1> $this->_TITLE </h1>
Google Plus のアカウントでログインします。<br>
ログイン後は 投稿が表示されます。<br>
<br>
<a href="?op=login">
[Google Plus アカウントでログインする]
</a><br>
<a href="http://linux.ohwada.jp/modules/smartsection/item.php?itemid=526" target="_blank">解説： Google Plus ログイン - Google API Client</a>
EOF;

	return $str;
}

function print_post_form( $user, $feeds )
{
	$flag  = $this->get_get_by_key( 'flag' );
	$error = $this->get_get_by_key( 'error' );

	$body  = $this->build_login_now( $user );
	$body .= $this->build_activity_feeds( $feeds );
//	$body .= $this->build_result_msg( $flag, $error );
//	$body .= $this->build_post_form();
	$this->print_html($body);
}

function build_login_now( $user )
{
	$url         = $this->get_array_value($user, 'url');
	$displayname = $this->get_array_value($user, 'displayname');
	$image_url   = $this->get_array_value($user, 'image_url');
	$tagline     = $this->get_array_value($user, 'tagline');

	$url_s     = $this->sanitize( $url );
	$name_s    = $this->sanitize( $displayname );
	$image_s   = $this->sanitize( $image_url );
	$tagline_s = $this->sanitize( $tagline );

	$str = <<< EOF
<h1> $this->_TITLE </h1>
<a href="?">[ホーム]</a> 
<a href="?op=logout">[ログアウト]</a> 
<br><br>
<table><tr><td valign="top">
<a href="$url_s" target="_blank">
<img src="$image_s">
</a>
</td><td valign="top">
<a href="$url_s" target="_blank"><b>$name_s</b></a>
<br><br>
$tagline_s
</td></tr></table>
EOF;

	return $str;
}

function build_activity_feeds( $feeds )
{
	$str  = '<br>'."\n";
	$str .= '<table>'."\n";
	foreach ( $feeds['items'] as $feed ) {
		$str .= $this->build_each_activity( $feed );
	}
	$str .= '</table>'."\n";
	return $str;
}

function build_each_activity( $feed )
{
	$url               = $this->get_array_value($feed, 'url');
	$published_date    = $this->get_array_value($feed, 'published_date');
	$actor_displayname = $this->get_array_value($feed, 'actor_displayname');
	$actor_url         = $this->get_array_value($feed, 'actor_url');
	$actor_image_url   = $this->get_array_value($feed, 'actor_image_url');
	$object_content    = $this->get_array_value($feed, 'object_content');

	$url_s         = $this->sanitize( $url );
	$date_s        = $this->sanitize( $published_date );
	$actor_name_s  = $this->sanitize( $actor_displayname );
	$actor_url_s   = $this->sanitize( $actor_url );
	$actor_image_s = $this->sanitize( $actor_image_url );

	$str = <<< EOF
<tr><td valign="top">
<a href="$actor_url_s" target="_blank">
<img src="$actor_image_s">
</a>
</td><td valign="top">
<a href="$actor_url_s" target="_blank"><b>$actor_name_s</b></a>
<br>
$object_content
<br>
<a href="$url_s" target="_blank">$date_s</a>
</td></tr>
EOF;

	return $str;
}

function build_a_href( $url )
{
	$begin = '';
	$end   = '';
	if ( $url ) {
		$begin = '<a href="'.$url.'" target="_blank">'."\n";
		$end   = '</a>'."\n";
	}
	return array( $begin, $end );
}

function build_result_msg( $flag, $error )
{
	$str = '';
	if ( $flag == 1 ) {
		$str .= '<p style="background-color: lightgreen;">ツィート 出来ました</p>
'."\n";
	} elseif ( $flag == -1 ) {
		$str .= '<p style="background-color: red;">う～ん！ google_plus に嫌われたみたい！</p>'."\n";
        $str .= '<div style="color: red;">';
		$str .= $error;
		$str .= '</div>'."\n";
	}

	return $str;
}

function get_array_value( $array, $key, $default=null )
{
	$str = isset($array[ $key ]) ? $array[ $key ] : $default;
	return $str;
}

function sanitize( $str )
{
	return htmlspecialchars( $str, ENT_QUOTES );
}

function build_tweet_form()
{

	$str = <<< EOF
<p>いまどうしてる？</p>
<form action="tweet.php" method="post" id="statusform">
<textarea name="$this->_NAME_STATUS" id="status" rows="2" cols="70%"></textarea>
<br/><input type="submit" id="submit" value="ツィートする"/>
</form>
EOF;

	return $str;
}

function print_html( $body )
{
	echo '<?xml version="1.0" encoding="UTF-8"?>';

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title><?php echo  $this->_TITLE; ?></title>
</head>
<body>
<?php echo $body; ?>
</body>
</html>
<?php
// --- print_tweet_form end --- 
}

// === class end ===
}

?>