<?php
// $Id: index.php,v 1.1.1.1 2011/12/15 02:18:04 ohwada Exp $

//=========================================================
// Google Plus Login with Google API Client
// 2011-12-12 K.OHWADA
//=========================================================

require_once 'common.inc.php';

session_start();

$op = isset($_GET['op']) ? $_GET['op'] : '' ;
if ( $op == 'login' ) {
	$service->set_flag_login( true );
	$service->login();

// always error, when return
	echo 'error code : '.$service->get_error_code()."<br>\n";
	echo $service->get_error_msg();
	exit();

} elseif ( $op == 'logout' ) {
	unset( $_SESSION['googleplus_user'] );
	header('Location: ' . $URL_INDEX );
	exit();

} elseif ( $op == 'clear' ) {
	unset( $_SESSION['googleplus_token'] );
	header('Location: ' . $URL_INDEX );
	exit();
}

if ( !isset( $_SESSION['googleplus_user'] ) ) {
	$misc->print_login_form();
	exit();
}

$service->set_client_access_token( $_SESSION['googleplus_token'] );

$user = $service->get_people( 'me' );
$user = $service->person_to_flat( $user );
$user = $service->convert_encoding_person( $user, 'UTF-8' );

$feeds = $service->get_activity_feeds( 'me', 10 );
$feeds = $service->activity_feeds_to_flat( $feeds );
$feeds = $service->convert_encoding_activity_feeds( $feeds, 'UTF-8' );

$misc->print_post_form( $user, $feeds );
exit();

?>