# debputy-lsp - Editor support for Debian packaging files

This project provides editor support for Debian packaging files via
the `debputy` language server (`debputy lsp server`). Any editor that
has [LSP] support (sometimes via plugin) from a compatible version of
the specification can use `debputy`'s language server to provide
extra features when working on Debian packaging files.

At the time of writing, the actual language server code is provided by
[`debputy`](https://salsa.debian.org/debian/debputy) itself. This repo
instead focuses on simplifying the installation, documentation and
providing editor configuration that be trivially moved out of the
`debputy` source.

The `debputy-lsp` and `debputy` repos are split on a technicality,
since `debputy` is also a packaging helper and therefore has to be
very conservative with both runtime and build-time dependencies from
the source package. The `debputy` source package is also a key package
(by virtue key packages using it as a build-dependency). Therefore,
adding an new binary package with extra depenencies would immediately
make all of them key packages.

Splitting out `debputy-lsp` into a separate repo grants it a lot more
freedom in that regard, which in turn enables it to be a lot more user
friendly in its promises and features without bloating the set of
Debian key packages. This matches prior art on this area with `cmake`,
which had its emacs support split into a separate `emacs-cmake-mode`
source package to avoid making parts of the emacs stack key packages.

[LSP]: https://microsoft.github.io/language-server-protocol/overviews/lsp/overview/

## What kind of editor features can I expect?

The LSP involves feature negotiation, so the concrete feature set
depends on the editor. Additionally, `debputy` also have some feature
limitations for certain files. Some common features are:

 * As-you-type diagnostics with quick-fixes
   (Use `debputy lint` for a batch version)
 * Context aware completion suggestions
 * In-editor access to documentation (often called "hover docs")

Other features include:

 * Reformat on save provided there is a known formatting
   (Check with `debputy reformat --no-auto-fix`)
 
## What kind of files are supported?

Source packaging files such as:

 * `debian/control`
 * `debian/copyright` (DEP-5 format only)
 * `debian/tests/control`
 * `debian/debputy.manifest`

Known omissions to support include any produced artifact or
"read-only" file from the build process such as:

 * `DEBIAN/control` (the .deb counter part of `debian/source`)
 * Any `*.dsc` or `*.changes` file

# Known issues

## Editor configuration - file type required

Editors need to know which language server to apply to which file
type and the language server specification deliberately does not
cover "how" this is done (only how the editor and the server will
communicate and how features work).

Most editors seem to prefer the approach of associating a file with
a type (usually relying on file patterns) and then the file type
can be associated with a language server.

This mechanism implies that has the weakness that to activate a
language server, the editor must have a basic file type declared
first. Since the Debian file types are very niche features, few
editors support these files types (or support them out of the box).

The simple solution is to ensure you install the optional file types
required as needed (like `elpa-dpkg-dev-el` for `emacs`) and then
associate the files with the most specific type you can.

However, you may find that some files cannot easily be linked to the
`debputy` language server because of this. Notably, support for
`debian/tests/control` is lot rarer than `debian/control` support,
which in turn reflects in `debputy`'s own suggestions for editor
configuration.

## Editor configuration - language IDs

By virtue of how the specification works, the editor is expected
to provide `debputy` with a language ID for the files being worked
on. The specification has a list of known language IDs for common
programming languages.

The Debian packaging files are *not* on this list, so there are no
known reference point for these language IDs. Instead, `debputy` has a
list of "acceptable" language IDs associated with the file names it
knows how to handle. As an example, when working on a `debian/control`
file, `debputy` will accept `debian/control`, `debian-control` and
`debcontrol` as "language ID" for that file. Additionally, if empty
language ID is provided, `debputy` uses filename based detection (is
the file named `.../debian/control`?) .

If you can control the language ID, please use the same name as the
file for maximum compatibility. Alternatively, if you have it use an
empty language ID that usually also works. However, if neither of
those are an option and the language ID used by the editor is not
supported by `debputy`, you can add the `--ignore-language-ids`
argument `debputy lsp server` command line and `debputy` will ignore
language IDs in favor of filename based detection. This has its
limitations in some corner cases. However, the common case should
work.

Note: For some case, `debputy` also does a filename based check.  As
an example, if `debputy` receives request with a language ID of `yaml`
(that ID is defined by the specification), then `debputy` only reacts
to it if the file is a known YAML-based file (at the time of writing
`debian/debputy.manifest` is the only supported case). This is to
enable using a standard language where necessary available (in case
the editor insists on sticking to only known language IDs).
