.\" dpkg manual page - dpkg-buildflags(1)
.\"
.\" Copyright © 2010-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011 Kees Cook <kees@debian.org>
.\" Copyright © 2011-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-buildflags 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-buildflags \- Renvoie les options de compilation à utiliser pour la
construction du paquet
.
.SH SYNOPSIS
\fBdpkg\-buildflags\fP [\fIoption\fP...] [\fIcommande\fP]
.
.SH DESCRIPTION
\fBdpkg\-buildflags\fP est un script qui permet de récupérer les options de
compilation à utiliser pour la construction d'un paquet.
.
Les drapeaux par défaut sont définis par le distributeur mais peuvent être
étendus ou remplacés de plusieurs façons\ :
.IP 1.
pour tout le système avec \fB%PKGCONFDIR%/buildflags.conf\fP\ ;
.IP 2.
pour l'utilisateur courant avec \fB$XDG_CONFIG_HOME/dpkg/buildflags.conf\fP où
la valeur par défaut de \fB$XDG_CONFIG_HOME\fP est \fB$HOME/.config\fP\ ;
.IP 3.
temporairement par l'utilisateur avec des variables d'environnement (voir
\fBVARIABLES D'ENVIRONNEMENT\fP)\ ;
.IP 4.
dynamiquement par le responsable du paquet avec des variables
d'environnement à l'aide de \fBdebian/rules\fP (voir \fBVARIABLES
D'ENVIRONNEMENT\fP).
.P
Les fichiers de configuration peuvent contenir quatre types de directives\ :
.TP 
\fBSET\fP\fI drapeau valeur\fP
Remplace le drapeau \fIdrapeau\fP par la valeur \fIvaleur\fP.
.TP 
\fBSTRIP\fP\fI drapeau valeur\fP
Retire du drapeau \fIdrapeau\fP tous les drapeaux de construction listés dans
\fIvaleur\fP.
.TP 
\fBAPPEND\fP\fI drapeau valeur\fP
Étend le drapeau \fIdrapeau\fP avec les options indiquées dans \fIvaleur\fP. Une
espace est ajoutée au début de ce qui est ajouté si la valeur actuelle du
drapeau n'est pas vide.
.TP 
\fBPREPEND\fP\fI drapeau valeur\fP
Préfixe le drapeau \fIdrapeau\fP avec les options indiquées dans \fIvaleur\fP. Une
espace est ajoutée au début de ce qui est ajouté si la valeur actuelle du
drapeau n'est pas vide.
.P
Les fichiers de configuration peuvent contenir des commentaires sur les
lignes commençant par un dièse (#). Les lignes vides sont également
ignorées.
.SH COMMANDES
.TP 
\fB\-\-dump\fP
Affiche sur la sortie standard tous les drapeaux de compilation et leurs
valeurs. Un drapeau par ligne est affiché, suivi de sa valeur, séparée par
le caractère «\ égal\ » («\ \fIdrapeau\fP=\fIvaleur\fP\ »). Il s'agit de l'action par
défaut.
.TP 
\fB\-\-list\fP
Affiche la liste des drapeaux gérés par le distributeur actuel (un par
ligne). Voir la section \fBDRAPEAUX GÉRÉS\fP pour plus d'informations sur
chacun d'eux.
.TP 
\fB\-\-status\fP
Affiche toute information utile pour expliquer le comportement de
\fBdpkg\-buildflags\fP (depuis dpkg\ 1.16.5)\ : variables  d'environnement,
distributeur actuel, état de tous les drapeaux de fonctionnalités. Affiche
également les drapeaux de compilation résultants ainsi que leur origine.

Cette option est destinée à être utilisée depuis \fBdebian/rules\fP, afin de
garder dans le journal de construction une trace claire des drapeaux de
compilation utilisés. Cela peut être utile pour diagnostiquer des problèmes
qui y seraient liés.
.TP 
\fB\-\-export=\fP\fIformat\fP
Affiche sur la sortie standard les commandes qui permettent d'exporter tous
les drapeaux de compilation pour un outil particulier. Si \fIformat\fP n'est
pas spécifié, sa valeur est \fBsh\fP. Seuls les drapeaux de compilation
commençant par une majuscule sont inclus, les autres étant supposés
inadaptés à l'environnement. Formats pris en charge\ :
.RS
.TP 
\fBsh\fP
Commandes shell pour définir et exporter tous les drapeaux de compilation
dans l'environnement. Les valeurs drapeau sont protégées et ainsi la sortie
est prête à être évaluée par un shell.
.TP 
\fBcmdline\fP
Arguments à passer à la ligne de commande d'un programme de construction
pour utiliser tous les drapeaux de compilation (depuis dpkg\ 1.17.0). Les
valeurs drapeau sont protégées dans la syntaxe du shell.
.TP 
\fBconfigure\fP
C'est un ancien alias pour \fBcmdline\fP.
.TP 
\fBmake\fP
Directives de make pour définir et exporter tous les drapeaux de compilation
dans l'environnement. La sortie peut être écrite dans un fragment de
makefile et évaluée en utilisant une directive \fBinclude\fP.
.RE
.TP 
\fB\-\-get\fP\fI drapeau\fP
Affiche la valeur de ce drapeau sur la sortie standard. Retourne un code de
sortie \fB0\fP si le drapeau est connu et \fB1\fP s'il est inconnu.
.TP 
\fB\-\-origin\fP\fI drapeau\fP
Affiche l'origine de la valeur renvoyée par \fB\-\-get\fP. Retourne un code de
sortie \fB0\fP si le drapeau est connu et \fB1\fP s'il est inconnu. L'origine est
une des valeurs suivantes\ :
.RS
.TP 
\fBvendor\fP
le drapeau défini à l'origine par le distributeur est renvoyé\ ;
.TP 
\fBsystem\fP
le drapeau est placé ou modifié par un réglage système\ ;
.TP 
\fBuser\fP
le drapeau est placé ou modifié par une configuration spécifique à
l'utilisateur\ ;
.TP 
\fBenv\fP
le drapeau est placé ou modifié par une configuration spécifique dans
l'environnement.
.RE
.TP 
\fB\-\-query\fP
Print any information that can be useful to explain the behaviour of the
program: current vendor, relevant environment variables, feature areas,
state of all feature flags, and the compiler flags with their origin (since
dpkg 1.19.0).
.IP
Par exemple\ :
.nf
  Vendor: Debian
  Environment:
   DEB_CFLAGS_SET=\-O0 \-Wall

  Area: qa
  Features:
   bug=no
   canary=no

  Area: reproducible
  Features:
   timeless=no

  Flag: CFLAGS
  Value: \-O0 \-Wall
  Origin: env

  Flag: CPPFLAGS
  Value: \-D_FORTIFY_SOURCE=2
  Origin: vendor
.fi
.TP 
\fB\-\-query\-features\fP\fI domaine\fP
Affiche les fonctionnalités activées pour un domaine donné (depuis
dpkg\ 1.16.2). Les seuls domaines reconnus actuellement sur Debian et ses
dérivés sont \fBfuture\fP, \fBqa\fP, \fBreproducible\fP, \fBsanitize\fP et \fBhardening\fP,
voir la section \fBZONES D'OPTION\fP pour plus de détails. Retourne un code de
sortie \fB0\fP si le domaine est connu et \fB1\fP s'il est inconnu.
.IP
L'affichage est dans le format RFC822, avec une section par
fonctionnalité. Par exemple\ :
.IP
.nf
  Feature: pie
  Enabled: yes

  Feature: stackprotector
  Enabled: yes
.fi
.TP 
\fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH "DRAPEAUX GÉRÉS"
.TP 
\fBCFLAGS\fP
Options du compilateur\ C. La valeur par défaut définie par le distributeur
comporte \fB\-g\fP et le niveau d'optimisation par défaut (\fB\-O2\fP en général, ou
\fB\-O0\fP si la variable d'environnement \fBDEB_BUILD_OPTIONS\fP contient
\fInoopt\fP).
.TP 
\fBCPPFLAGS\fP
Options du préprocesseur\ C. Valeur par défaut\ :\ aucune.
.TP 
\fBCXXFLAGS\fP
Options du compilateur\ C++. Analogue à \fBCFLAGS\fP.
.TP 
\fBOBJCFLAGS\fP
Options du compilateur Objective\ C. Analogue à \fBCFLAGS\fP.
.TP 
\fBOBJCXXFLAGS\fP
Options du compilateur Objective\ C++. Analogue à \fBCXXFLAGS\fP.
.TP 
\fBGCJFLAGS\fP
Options du compilateur Java GNU (gcj). Un sous\-ensemble de \fBCFLAGS\fP.
.TP 
\fBFFLAGS\fP
Options du compilateur Fortran\ 77. Un sous\-ensemble de \fBCFLAGS\fP.
.TP 
\fBFCFLAGS\fP
Options du compilateur Fortran\ 9x. Analogue à \fBFFLAGS\fP.
.TP 
\fBLDFLAGS\fP
Options passées au compilateur lors du processus de liaison des exécutables
ou des objets partagés (si le linker est appelé directement, alors \fB\-Wl\fP et
\fB,\fP doivent être retirés de ces options). Valeur par défaut\ :\ aucune.
.PP
De nouveaux drapeaux pourront être ajoutés si besoin est (par exemple pour
la prise en charge de nouveaux langages).
.
.SH "ZONES D'OPTION"
.P
Chaque option de zone peut être activée ou désactivée avec les valeurs
\fBDEB_BUILD_OPTIONS\fP et \fBDEB_BUIL_MAINT_OPTIONS\fP de l'espace de variables
d'environnement grâce aux modificateurs «\ \fB+\fP\ » et «\ \fB\-\fP\ ». Par exemple,
pour activer l'option \fBhardening\fP «\ pie\ » et désactiver l'option
«\ fortify\ », il est possible d'indiquer cela dans \fBdebian/rules\fP\ :
.P
  export DEB_BUILD_MAINT_OPTIONS=hardening=+pie,\-fortify
.P
L'option spéciale \fBall\fP (valable dans toutes les zones) peut être utilisée
pour activer ou désactiver toutes les options de la zone à la fois. Ainsi,
tout désactiver dans la zone \fBhardening\fP en n'activant que «\ format\ » et
«\ fortify\ » peut être réalisé avec\ :
.P
  export DEB_BUILD_MAINT_OPTIONS=hardening=\-all,+format,+fortify
.
.SS future
Plusieurs options de compilation (détaillées ci\-dessous) peuvent être
utilisées pour activer des fonctionnalités qui devraient être activées par
défaut, mais ne peuvent pas l'être pour des raisons de compatibilité avec
les versions précédentes.
.TP 
\fBlfs\fP
Ce paramètre (désactivé par défaut) active la prise en charge des gros
fichiers (LFS) sur les architectures 32\ bits où l'ABI n'inclut pas LFS par
défaut, en ajoutant \fB\-D_LARGEFILE_SOURCE \-D_FILE_OFFSET_BITS=64\fP à
\fBCPPFLAGS\fP.
.
.SS qa
Plusieurs options de compilation (détaillées ci\-dessous) peuvent être
utilisées pour détecter des problèmes dans le code source ou dans le système
de construction.
.TP 
\fBbug\fP
Ce paramètre (désactivé par défaut) ajoute toutes les options
d'avertissement détectant de façon fiable du code source problématique. Les
avertissements sont fatals. Les seuls drapeaux actuellement gérés sont
\fBCFLAGS\fP et \fBCXXFLAGS\fP avec des drapeaux définis à
\fB\-Werror=array\-bounds\fP, \fB\-Werror=clobbered\fP,
\fB\-Werror=implicit\-function\-declaration\fP et
\fB\-Werror=volatile\-register\-var\fP.
.
.TP 
\fBcanary\fP
Ce paramètre (désactivé par défaut) ajoute des options détectrices
«\ canary\ » factices aux drapeaux de construction de telle sorte que les
rapports de compilation permettront de vérifier la façon dont ces drapeaux
se propagent et de repérer toute omission des paramètres de drapeaux
habituels. Les drapeaux actuellement pris en charge sont \fBCPPFLAGS\fP,
\fBCFLAGS\fP, \fBOBJCFLAGS\fP, \fBCXXFLAGS\fP ainsi que \fBOBJCXXFLAGS\fP, avec les
drapeaux définis à \fB\-D__DEB_CANARY_\fP\fIflag\fP_\fIrandom\-id\fP\fB__\fP, et
\fBLDFLAGS\fP paramétré à \fB\-Wl,\-z,deb\-canary\-\fP\fIrandom\-id\fP.
.
.SS sanitize
Plusieurs options de compilation (détaillées ci\-dessous) peuvent être
utilisées pour aider à nettoyer le binaire compilé face aux corruptions de
la mémoire, aux fuites de mémoire, à l'utilisation de mémoire après
libération et à des bogues au comportement indéfini. \fBNote\fP\ : ces options
ne devraient pas être utilisées pour des constructions en production car
elles peuvent réduire la fiabilité du code, réduire la sécurité ou même les
fonctionnalités.
.TP 
\fBaddress\fP
Ce paramètre (désactivé par défaut) ajoute \fB\-fsanitize=address\fP à
\fBLDFLAGS\fP et \fB\-fsanitize=address \-fno\-omit\-frame\-pointer\fP à \fBCFLAGS\fP et
\fBCXXFLAGS\fP.
.TP 
\fBthread\fP
Ce paramètre (désactivé par défaut) ajoute \fB\-fsanitize=thread\fP à \fBCFLAGS\fP,
\fBCXXFLAGS\fP et \fBLDFLAGS\fP.
.TP 
\fBleak\fP
Ce paramètre (désactivé par défaut) ajoute \fB\-fsanitize=leak\fP à
\fBLDFLAGS\fP. Il est automatiquement désactivé si les fonctions \fBaddress\fP ou
\fBthread\fP sont activées, parce qu'elles l'impliquent.
.TP 
\fBundefined\fP
Ce paramètre (désactivé par défaut) ajoute \fB\-fsanitize=undefined\fP à
\fBCFLAGS\fP, \fBCXXFLAGS\fP et \fBLDFLAGS\fP.
.SS "compilation renforcée"
Plusieurs options de compilation (détaillées ci\-dessous) peuvent être
utilisées pour accroître la résistance du binaire compilé face aux attaques
par corruption de la mémoire ou fournir des messages d'avertissement
supplémentaires lors de la compilation. Sauf mention contraire (voir
ci\-dessous), ces options sont activées par défaut pour les architectures qui
les gèrent.
.TP 
\fBformat\fP
Ce réglage, activé par défaut, ajoute \fB\-Wformat \-Werror=format\-security\fP à
\fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP et \fBOBJCXXFLAGS\fP. Cela provoquera
l'avertissement en cas d'utilisation de chaînes de formatage incorrectes et
échouera si les fonctions de formatage sont utilisées d'une façon qui
présente des risques pour la sécurité. Actuellement, ce réglage crée des
avertissements pour les appels des fonctions \fBprintf\fP et \fBscanf\fP lorsque
la chaîne de formatage n'est pas une chaîne littérale et qu'aucun paramètre
de formatage n'est utilisé (par exemple dans \fBprintf(foo);\fP au lieu de \fB
printf("%s", foo);\fP. Ce type de syntaxe peut créer un problème de sécurité
si la chaîne de formatage vient d'une source non sûre et contient «\ %n\ ».
.
.TP 
\fBfortify\fP
Ce réglage, activé par défaut, ajoute \fB\-D_FORTIFY_SOURCE=2\fP à
\fBCPPFLAGS\fP. Lors de la création du code, le compilateur connaît un nombre
important d'informations relatives aux tailles de tampons (quand c'est
possible) et tente alors de remplacer des appels de fonctions avec une
taille illimitée de tampons, peu sûrs, par des appels avec des tampons de
taille limitée. Cette fonctionnalité est particulièrement utile pour du code
ancien et mal écrit. De plus, les chaînes de formatage dans la mémoire
accessible en écriture qui contiennent «\ %n\ » sont bloquées. Si une
application dépend de telles chaînes de formatage, un contournement devra
être mis en place.

Veuillez noter que pour que cette option fasse effet, la source devra aussi
être compilée avec \fB\-O1\fP ou plus. Si la variable d'environnement
\fBDEB_BUILD_OPTIONS\fP contient \fInoopt\fP, la prise en charge de \fBfortify\fP
sera désactivée du fait des nouveaux avertissements émis par glibc
version\ 2.16 et ultérieure.
.TP 
\fBstackprotector\fP
Ce réglage (activé par défaut si stackprotectorstrong n'est pas employé),
ajoute \fB\-fstack\-protector \-\-param=ssp\-buffer\-size=4\fP à \fBCFLAGS\fP,
\fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP et
\fBFCFLAGS\fP. Il ajoute des contrôles liés aux réécritures de piles. Cela
conduit des tentatives d'attaques par injection de code à terminer en
échec. Dans le meilleur des cas, cette protection transforme une
vulnérabilité d'injection de code en déni de service ou en non\-problème
(selon les applications).

Cette fonctionnalité impose de lier le code à glibc (ou toute autre
bibliothèque fournissant \fB__stack_chk_fail\fP) et doit donc être désactivée
lorsque le code est construit avec \fB\-nostdlib\fP, \fB\-ffreestanding\fP ou
équivalents.
.
.TP 
\fBstackprotectorstrong\fP
Ce réglage, activé par défaut, ajoute \fB\-fstack\-protector\-strong\fP à
\fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP
et \fBFCFLAGS\fP. Il s'agit d'une version renforcée de \fBstackprotector\fP qui
n'affecte pas les performances de manière importante.

Désactiver \fBstackprotector\fP désactive également ce paramètre.

Cette fonctionnalité a les même exigences que \fBstackprotector\fP, en plus de
nécessiter gcc\ 4.9 ou plus récent.
.
.TP 
\fBrelro\fP
Ce réglage, activé par défaut, ajoute \fB\-Wl,\-z,relro\fP à \fBLDFLAGS\fP. Lors du
chargement du programme, plusieurs parties de la mémoire ELF doivent être
écrites par l'éditeur de liens. Ce réglage indique au chargeur de mettre ces
sections en lecture seule avant de rendre le contrôle au
programme. L'utilisation habituelle de ce réglage est la protection contre
les attaques par réécriture GOT. Si cette option est désactivée, l'option
\fBbindnow\fP sera également désactivée.
.
.TP 
\fBbindnow\fP
Ce réglage, désactivé par défaut, ajoute \fB\-Wl,\-z,now\fP à \fBLDFLAGS\fP. Lors du
chargement du programme, tous les symboles dynamiques sont résolus, ce qui
permet au PLT (Procedure Linkage Table) entier d'être en lecture seule (du
fait du réglage \fBrelro\fP ci\-dessus). Cette option ne peut être activée si
\fBrelro\fP ne l'est pas.
.
.TP 
\fBpie\fP
Ce réglage (sans option globale par défaut depuis dpkg\ 1.18.23, parce qu'il
est maintenant activé par défaut par gcc dans les architectures Debian
amd64, arm64, armel, armhf, hurd\-i386, i386, kfreebsd\-amd64, kfreebsd\-i386,
mips, mipsel, mips64el, powerpc, ppc64, ppc64el, riscv64, s390x, sparc et
sparc64) ajoute les options requises pour activer ou désactiver PIE
(exécutable indépendant de l'emplacement) au moyen des fichiers de
spécifications de gcc, si nécessaire, selon que gcc injecte sur cette
architecture les drapeaux par lui\-même ou non. Si le réglage est activé et
que gcc injecte les drapeaux, il n'ajoute rien. Si le réglage est activé et
que gcc n'injecte pas les drapeaux, il ajoute \fB\-fPIE\fP (au moyen de
\fI%PKGDATADIR%/pie\-compiler.specs\fP) à \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP,
\fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP et \fBFCFLAGS\fP, et \fB\-fPIE \-pie\fP (au
moyen de \fI%PKGDATADIR%/pie\-link.specs\fP) à \fBLDFLAGS\fP. Si le réglage est
désactivé et que gcc injecte les drapeaux, il ajoute \fB\-fno\-PIE\fP (au moyen
de \fI%PKGDATADIR%/no\-pie\-compile.specs\fP) à \fBCFLAGS\fP, \fBCXXFLAGS\fP,
\fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP et \fBFCFLAGS\fP, et
\fB\-fno\-PIE \-no\-pie\fP (au moyen de \fI%PKGDATADIR%/no\-pie\-link.specs\fP) à
\fBLDFLAGS\fP.

Les exécutables à position indépendante («\ Position Independent
Executable\ ») permettent d'utiliser la randomisation de l'organisation de
l'espace d'adressage (ASLR\ :\ «\ Address Space Layout Randomization\ »), qui
est gérée par certaines versions du noyau. Bien que ASLR puisse déjà être
mise en œuvre pour les zones de données dans la pile et le tampon (brk et
mmap), les zones de codes doivent être compilées comme indépendantes de la
position. Les bibliothèques partagées font déjà cela (\fB\-fPIC\fP) ce qui
permet automatiquement d'utiliser ASLR. Par contre les régions .text
binaires doivent être construites en mode PIE pour mettre en œuvre ASLR. Une
fois cela réalisé, les attaques ROP («\ Return Oriented Programming\ »)
deviennent plus difficiles car il n'existe pas d'emplacement statique d'où
rebondir pendant une attaque par corruption de la mémoire.

PIE n'est pas compatible avec \fBfPIC\fP, aussi, en général, des précautions
doivent être prises lors de la construction d'objets partagés. Mais comme
les drapeaux PIE émis sont injectés par des fichiers de spécifications de
gcc, il devrait toujours être sûr de les définir sans condition
indépendamment du type d'objet en train d'être compilé ou lié.

Les bibliothèques statiques peuvent être utilisées par des programmes ou
d'autres bibliothèques partagées. Selon les drapeaux utilisés pour compiler
tous les objets d'une bibliothèque statique, ces bibliothèques seront
utilisables par divers ensembles d'objets\ :

.RS
.TP 
\fBnone\fP
Ne peut être lié ni à un programme PIE, ni à une bibliothèque partagée.
.TP 
\fB\-fPIE\fP
Peut être lié à tout programme, mais pas à une bibliothèque partagée
(recommandé).
.TP 
\fB\-fPIC\fP
Peut être lié à tout programme et toute bibliothèque partagée.
.RE

.IP
S'il est nécessaire de régler ces drapeaux manuellement, en contournant
l'injonction des spécifications de gcc, il y a plusieurs choses à prendre en
compte. Le passage sans condition et de façon explicite de \fB\-fPIE\fP,
\fB\-fpie\fP ou \fB\-pie\fP à un système de construction en utilisant libtool est
sûr dans la mesure où ces drapeaux seront retirés lors de la construction de
bibliothèques partagées. Sinon, sur les projets qui construisent à la fois
des programmes et des bibliothèques partagées, il faudrait s'assurer que,
lors de la construction des bibliothèques partagées, \fB\-fPIC\fP soit toujours
passé en dernier aux drapeaux de compilation tels que \fBCFLAGS\fP (de sorte
qu'il remplace tout \fB\-PIE\fP antérieur), et que \fB\-shared\fP soit passé en
dernier aux drapeaux de création de lien tels que \fBLDFLAGS\fP (de sorte qu'il
remplace tout \fB\-pie\fP antérieur). \fBNote\fP\ : Cela ne devrait pas être
nécessaire avec les mécanismes de spécification de gcc par défaut.

.IP
De plus, comme la protection PIE est mise en œuvre à l'aide d'un registre
global, certaines architectures privées de registre (mais plus i386 depuis
les optimisations mises en œuvre dans gcc\ >=\ 5) peuvent souffrir de
pertes de performances allant jusqu'à 15\ % sur des charges d'applications
utilisant largement les segments de texte\ ; le plus souvent, cette perte de
performances n’excédera pas\ 1\ %. Pour des architectures offrant plus de
registres globaux (par exemple amd64), cette pénalisation n'existe
pratiquement pas.
.SS reproductible
Les options de compilation (détaillées ci\-dessous) peuvent aider à améliorer
la reproductibilité de la construction ou fournir des messages
d'avertissement supplémentaires lors de la compilation. Sauf mention
contraire (voir ci\-dessous), ces options sont activées par défaut pour les
architectures qui les gèrent.
.TP 
\fBtimeless\fP
Ce paramètre, activé par défaut, ajoute \fB\-Wdate\-time\fP à \fBCPPFLAGS\fP. Cela
provoquera des avertissements quand les macros \fB__TIME__\fP, \fB__DATE__\fP et
\fB__TIMESTAMP__\fP sont utilisées.
.
.TP 
\fBfixfilepath\fP
Ce paramètre, désactivé par défaut, ajoute
\fB\-ffile\-prefix\-map=\fP\fIBUILDPATH\fP\fB=.\fP à \fBCFLAGS\fP, \fBCXXFLAGS\fP,
\fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP et \fBFCFLAGS\fP où
\fBBUILDPATH\fP est fixé sur le répertoire de plus haut niveau du paquet en
construction. Cela a pour effet de retirer le chemin de construction de tout
fichier généré.

Si à la fois \fBfixdebugpath\fP et \fBfixfilepath\fP sont définis, cette option a
la priorité parce c'est un sur\-ensemble du premier.
.TP 
\fBfixdebugpath\fP
Ce réglage, activé par défaut, ajoute
\fB\-fdebug\-prefix\-map=\fP\fIBUILDPATH\fP\fB=.\fP à \fBCFLAGS\fP, \fBCXXFLAGS\fP,
\fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP et \fBFCFLAGS\fP où
\fBBUILDPATH\fP est fixé sur le répertoire de plus haut niveau du paquet en
construction. Cela a pour effet de retirer le chemin de construction de tous
les symboles de débogage générés.
.
.SH ENVIRONNEMENT
Deux jeux de variables d'environnement effectuent les mêmes opérations. Le
premier (DEB_\fIdrapeau\fP_\fIopération\fP) ne devrait jamais être utilisé depuis
\fBdebian/rules\fP. Il est destiné aux utilisateurs souhaitant recompiler le
paquet source avec des drapeaux de compilation modifiés. Le second
(DEB_\fIdrapeau\fP_MAINT_\fIopération\fP) ne doit être utilisé que dans
\fBdebian/rules\fP par les responsables de paquets pour modifier les drapeaux
de compilation concernés.
.TP 
\fBDEB_\fP\fIdrapeau\fP\fB_SET\fP
.TQ
\fBDEB_\fP\fIdrapeau\fP\fB_MAINT_SET\fP
Cette variable permet de forcer la valeur renvoyée pour le \fIdrapeau\fP
indiqué.
.TP 
\fBDEB_\fP\fIdrapeau\fP\fB_STRIP\fP
.TQ
\fBDEB_\fP\fIdrapeau\fP\fB_MAINT_STRIP\fP
Cette variable peut être utilisée pour fournir une liste d'options (séparées
par des espaces) qui seront retirées du jeu de drapeaux renvoyé pour le
\fIdrapeau\fP indiqué.
.TP 
\fBDEB_\fP\fIdrapeau\fP\fB_APPEND\fP
.TQ
\fBDEB_\fP\fIdrapeau\fP\fB_MAINT_APPEND\fP
Cette variable permet d'ajouter des options à la valeur renvoyée pour le
\fIdrapeau\fP indiqué.
.TP 
\fBDEB_\fP\fIdrapeau\fP\fB_PREPEND\fP
.TQ
\fBDEB_\fP\fIdrapeau\fP\fB_MAINT_PREPEND\fP
Cette variable permet de préfixer la valeur renvoyée pour le \fIdrapeau\fP
indiqué par des options supplémentaires.
.TP 
\fBDEB_BUILD_OPTIONS\fP
.TQ
\fBDEB_BUILD_MAINT_OPTIONS\fP
Ces variables peuvent être utilisées par un utilisateur ou un responsable de
paquet pour activer ou désactiver différentes options de zone qui affectent
les drapeaux de construction. La variable \fBDEB_BUILD_MAINT_OPTIONS\fP
outrepasse tous les paramètres de la zone d'options
\fBDEB_BUILD_OPTIONS\fP. Voir la section \fBZONES D'OPTION\fP pour plus de
détails.
.TP 
\fBDEB_VENDOR\fP
Ce réglage définit l'éditeur («\ vendor\ ») actuel. Si cette valeur est vide,
le contenu du fichier \fB%PKGCONFDIR%/origins/default\fP est utilisé.
.TP 
\fBDEB_BUILD_PATH\fP
Cette variable configure le chemin de construction (depuis dpkg\ 1.18.8) à
utiliser avec des fonctions telles que \fBfixdebugpath\fP de telle sorte
qu'elles soient contrôlées par l'appelant. Cette variable est actuellement
spécifique à Debian et à ses dérivés.
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.
.SH FICHIERS
.SS "Fichiers de configuration."
.TP 
\fB%PKGCONFDIR%/buildflags.conf\fP
Fichier de configuration pour l'ensemble du système.
.TP 
\fB$XDG_CONFIG_HOME/dpkg/buildflags.conf\fP ou 
.TQ
\fB$HOME/.config/dpkg/buildflags.conf\fP
Fichier de configuration propre à l'utilisateur
.SS "Gestion de l'empaquetage"
.TP 
\fB%PKGDATADIR%/buildflags.mk\fP
Fragment de fichier Makefile qui chargera (et facultativement exportera)
dans les variables (depuis dpkg\ 1.16.1) tous les drapeaux pris en charge par
\fBdpkg\-buildflags\fP.
.
.SH EXEMPLES
Pour passer des drapeaux de compilation à une commande de compilation dans
un Makefile\ :
.PP
.RS 4
.nf
$(MAKE) $(shell dpkg\-buildflags \-\-export=cmdline)

\&./configure $(shell dpkg\-buildflags \-\-export=cmdline)
.fi
.RE
.PP
Pour définir les drapeaux de compilation dans un script shell ou un fragment
de shell, on peut utiliser \fBeval\fP pour interpréter la sortie et exporter
les drapeaux dans l'environnement\ :
.PP
.RS 4
.nf
eval "$(dpkg\-buildflags \-\-export=sh)" && make
.fi
.RE
.PP
ou définir les paramètres de position à passer à la commande\ :
.PP
.RS 4
.nf
eval "set \-\- $(dpkg\-buildflags \-\-export=cmdline)"
for dir in a b c; do (cd $dir && ./configure "$@" && make); done
.fi
.RE
.
.SS "Utilisation dans debian/rules"
Il faut appeler \fBdpkg\-buildflags\fP ou inclure \fBbuildflags.mk\fP à partir du
fichier \fBdebian/rules\fP pour obtenir les drapeaux de compilation nécessaires
à passer au système de construction. Veuillez noter que les anciennes
versions de \fBdpkg\-buildpackage\fP (antérieures à dpkg\ 1.16.1) exportaient ces
drapeaux automatiquement. Néanmoins, il est déconseillé de dépendre de ce
comportement parce qu'il casse l'appel manuel de \fBdebian/rules\fP.
.PP
Pour les paquets avec des systèmes de construction du style autoconf, il est
possible de passer les options appropriées à configure ou \fBmake\fP(1)
directement, comme vu ci\-dessus.
.PP
Pour d'autres systèmes de construction ou si on souhaite un contrôle
extrêmement précis sur le choix et la position où sont passés les drapeaux,
\fB\-\-get\fP peut être utilisé. Autrement, il est possible d'inclure
\fBbuildflags.mk\fP qui s'occupe de l'appel de \fBdpkg\-buildflags\fP et du
placement des drapeaux de compilation dans les variables de make.
.PP
Si vous voulez exporter tous les drapeaux de compilation dans
l'environnement (où le système de construction peut les récupérer)\ :
.PP
.RS 4
.nf
DPKG_EXPORT_BUILDFLAGS = 1
include %PKGDATADIR%/buildflags.mk
.fi
.RE
.PP
Pour un contrôle supplémentaire sur ce qui est exporté, vous pouvez exporter
manuellement les variables (puisque aucune n'est exportée par défaut)\ :
.PP
.RS 4
.nf
include %PKGDATADIR%/buildflags.mk
export CPPFLAGS CFLAGS LDFLAGS
.fi
.RE
.PP
Et enfin, vous pouvez bien sûr passer manuellement les drapeaux aux
commandes\ :
.PP
.RS 4
.nf
include %PKGDATADIR%/buildflags.mk
build\-arch:
\&	$(CC) \-o hello hello.c $(CPPFLAGS) $(CFLAGS) $(LDFLAGS)
.fi
.RE
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
