// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file CalculatorTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "CalculatorTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "Calculator.hpp"


using namespace eprosima::fastdds::dds::xtypes;

void register_CalculatorOperationType_type_identifier(
        TypeIdentifierPair& type_ids_CalculatorOperationType)
{
    ReturnCode_t return_code_CalculatorOperationType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_CalculatorOperationType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "CalculatorOperationType", type_ids_CalculatorOperationType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_CalculatorOperationType)
    {
        EnumTypeFlag enum_flags_CalculatorOperationType = 0;
        BitBound bit_bound_CalculatorOperationType = 32;
        CommonEnumeratedHeader common_CalculatorOperationType = TypeObjectUtils::build_common_enumerated_header(bit_bound_CalculatorOperationType);
        QualifiedTypeName type_name_CalculatorOperationType = "CalculatorOperationType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_CalculatorOperationType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_CalculatorOperationType;
        AppliedAnnotationSeq tmp_ann_custom_CalculatorOperationType;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_CalculatorOperationType;
        if (!tmp_ann_custom_CalculatorOperationType.empty())
        {
            ann_custom_CalculatorOperationType = tmp_ann_custom_CalculatorOperationType;
        }

        CompleteTypeDetail detail_CalculatorOperationType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_CalculatorOperationType, ann_custom_CalculatorOperationType, type_name_CalculatorOperationType.to_string());
        CompleteEnumeratedHeader header_CalculatorOperationType = TypeObjectUtils::build_complete_enumerated_header(common_CalculatorOperationType, detail_CalculatorOperationType);
        CompleteEnumeratedLiteralSeq literal_seq_CalculatorOperationType;
        {
            EnumeratedLiteralFlag flags_ADDITION = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_ADDITION = TypeObjectUtils::build_common_enumerated_literal(0, flags_ADDITION);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ADDITION;
            ann_custom_CalculatorOperationType.reset();
            MemberName name_ADDITION = "ADDITION";
            CompleteMemberDetail detail_ADDITION = TypeObjectUtils::build_complete_member_detail(name_ADDITION, member_ann_builtin_ADDITION, ann_custom_CalculatorOperationType);
            CompleteEnumeratedLiteral literal_ADDITION = TypeObjectUtils::build_complete_enumerated_literal(common_ADDITION, detail_ADDITION);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_CalculatorOperationType, literal_ADDITION);
        }
        {
            EnumeratedLiteralFlag flags_SUBTRACTION = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_SUBTRACTION = TypeObjectUtils::build_common_enumerated_literal(1, flags_SUBTRACTION);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_SUBTRACTION;
            ann_custom_CalculatorOperationType.reset();
            MemberName name_SUBTRACTION = "SUBTRACTION";
            CompleteMemberDetail detail_SUBTRACTION = TypeObjectUtils::build_complete_member_detail(name_SUBTRACTION, member_ann_builtin_SUBTRACTION, ann_custom_CalculatorOperationType);
            CompleteEnumeratedLiteral literal_SUBTRACTION = TypeObjectUtils::build_complete_enumerated_literal(common_SUBTRACTION, detail_SUBTRACTION);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_CalculatorOperationType, literal_SUBTRACTION);
        }
        {
            EnumeratedLiteralFlag flags_MULTIPLICATION = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_MULTIPLICATION = TypeObjectUtils::build_common_enumerated_literal(2, flags_MULTIPLICATION);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_MULTIPLICATION;
            ann_custom_CalculatorOperationType.reset();
            MemberName name_MULTIPLICATION = "MULTIPLICATION";
            CompleteMemberDetail detail_MULTIPLICATION = TypeObjectUtils::build_complete_member_detail(name_MULTIPLICATION, member_ann_builtin_MULTIPLICATION, ann_custom_CalculatorOperationType);
            CompleteEnumeratedLiteral literal_MULTIPLICATION = TypeObjectUtils::build_complete_enumerated_literal(common_MULTIPLICATION, detail_MULTIPLICATION);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_CalculatorOperationType, literal_MULTIPLICATION);
        }
        {
            EnumeratedLiteralFlag flags_DIVISION = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_DIVISION = TypeObjectUtils::build_common_enumerated_literal(3, flags_DIVISION);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_DIVISION;
            ann_custom_CalculatorOperationType.reset();
            MemberName name_DIVISION = "DIVISION";
            CompleteMemberDetail detail_DIVISION = TypeObjectUtils::build_complete_member_detail(name_DIVISION, member_ann_builtin_DIVISION, ann_custom_CalculatorOperationType);
            CompleteEnumeratedLiteral literal_DIVISION = TypeObjectUtils::build_complete_enumerated_literal(common_DIVISION, detail_DIVISION);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_CalculatorOperationType, literal_DIVISION);
        }
        CompleteEnumeratedType enumerated_type_CalculatorOperationType = TypeObjectUtils::build_complete_enumerated_type(enum_flags_CalculatorOperationType, header_CalculatorOperationType,
                literal_seq_CalculatorOperationType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_CalculatorOperationType, type_name_CalculatorOperationType.to_string(), type_ids_CalculatorOperationType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "CalculatorOperationType already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_CalculatorRequestType_type_identifier(
        TypeIdentifierPair& type_ids_CalculatorRequestType)
{

    ReturnCode_t return_code_CalculatorRequestType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_CalculatorRequestType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "CalculatorRequestType", type_ids_CalculatorRequestType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_CalculatorRequestType)
    {
        StructTypeFlag struct_flags_CalculatorRequestType = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_CalculatorRequestType = "CalculatorRequestType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_CalculatorRequestType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_CalculatorRequestType;
        AppliedAnnotationSeq tmp_ann_custom_CalculatorRequestType;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_CalculatorRequestType;
        if (!tmp_ann_custom_CalculatorRequestType.empty())
        {
            ann_custom_CalculatorRequestType = tmp_ann_custom_CalculatorRequestType;
        }

        CompleteTypeDetail detail_CalculatorRequestType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_CalculatorRequestType, ann_custom_CalculatorRequestType, type_name_CalculatorRequestType.to_string());
        CompleteStructHeader header_CalculatorRequestType;
        header_CalculatorRequestType = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_CalculatorRequestType);
        CompleteStructMemberSeq member_seq_CalculatorRequestType;
        {
            TypeIdentifierPair type_ids_client_id;
            ReturnCode_t return_code_client_id {eprosima::fastdds::dds::RETCODE_OK};
            return_code_client_id =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_client_id);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_client_id)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_client_id))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_client_id = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_client_id = 0x00000000;
            bool common_client_id_ec {false};
            CommonStructMember common_client_id {TypeObjectUtils::build_common_struct_member(member_id_client_id, member_flags_client_id, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_client_id, common_client_id_ec))};
            if (!common_client_id_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure client_id member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_client_id = "client_id";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_client_id;
            ann_custom_CalculatorRequestType.reset();
            AppliedAnnotationSeq tmp_ann_custom_client_id;
            eprosima::fastcdr::optional<std::string> unit_client_id;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_client_id;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_client_id;
            eprosima::fastcdr::optional<std::string> hash_id_client_id;
            if (unit_client_id.has_value() || min_client_id.has_value() || max_client_id.has_value() || hash_id_client_id.has_value())
            {
                member_ann_builtin_client_id = TypeObjectUtils::build_applied_builtin_member_annotations(unit_client_id, min_client_id, max_client_id, hash_id_client_id);
            }
            if (!tmp_ann_custom_client_id.empty())
            {
                ann_custom_CalculatorRequestType = tmp_ann_custom_client_id;
            }
            CompleteMemberDetail detail_client_id = TypeObjectUtils::build_complete_member_detail(name_client_id, member_ann_builtin_client_id, ann_custom_CalculatorRequestType);
            CompleteStructMember member_client_id = TypeObjectUtils::build_complete_struct_member(common_client_id, detail_client_id);
            TypeObjectUtils::add_complete_struct_member(member_seq_CalculatorRequestType, member_client_id);
        }
        {
            TypeIdentifierPair type_ids_operation;
            ReturnCode_t return_code_operation {eprosima::fastdds::dds::RETCODE_OK};
            return_code_operation =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "CalculatorOperationType", type_ids_operation);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_operation)
            {
            ::register_CalculatorOperationType_type_identifier(type_ids_operation);
            }
            StructMemberFlag member_flags_operation = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_operation = 0x00000001;
            bool common_operation_ec {false};
            CommonStructMember common_operation {TypeObjectUtils::build_common_struct_member(member_id_operation, member_flags_operation, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_operation, common_operation_ec))};
            if (!common_operation_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure operation member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_operation = "operation";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_operation;
            ann_custom_CalculatorRequestType.reset();
            CompleteMemberDetail detail_operation = TypeObjectUtils::build_complete_member_detail(name_operation, member_ann_builtin_operation, ann_custom_CalculatorRequestType);
            CompleteStructMember member_operation = TypeObjectUtils::build_complete_struct_member(common_operation, detail_operation);
            TypeObjectUtils::add_complete_struct_member(member_seq_CalculatorRequestType, member_operation);
        }
        {
            TypeIdentifierPair type_ids_x;
            ReturnCode_t return_code_x {eprosima::fastdds::dds::RETCODE_OK};
            return_code_x =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_x);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_x)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "x Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_x = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_x = 0x00000002;
            bool common_x_ec {false};
            CommonStructMember common_x {TypeObjectUtils::build_common_struct_member(member_id_x, member_flags_x, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_x, common_x_ec))};
            if (!common_x_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure x member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_x = "x";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_x;
            ann_custom_CalculatorRequestType.reset();
            CompleteMemberDetail detail_x = TypeObjectUtils::build_complete_member_detail(name_x, member_ann_builtin_x, ann_custom_CalculatorRequestType);
            CompleteStructMember member_x = TypeObjectUtils::build_complete_struct_member(common_x, detail_x);
            TypeObjectUtils::add_complete_struct_member(member_seq_CalculatorRequestType, member_x);
        }
        {
            TypeIdentifierPair type_ids_y;
            ReturnCode_t return_code_y {eprosima::fastdds::dds::RETCODE_OK};
            return_code_y =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_y);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_y)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "y Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_y = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_y = 0x00000003;
            bool common_y_ec {false};
            CommonStructMember common_y {TypeObjectUtils::build_common_struct_member(member_id_y, member_flags_y, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_y, common_y_ec))};
            if (!common_y_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure y member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_y = "y";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_y;
            ann_custom_CalculatorRequestType.reset();
            CompleteMemberDetail detail_y = TypeObjectUtils::build_complete_member_detail(name_y, member_ann_builtin_y, ann_custom_CalculatorRequestType);
            CompleteStructMember member_y = TypeObjectUtils::build_complete_struct_member(common_y, detail_y);
            TypeObjectUtils::add_complete_struct_member(member_seq_CalculatorRequestType, member_y);
        }
        CompleteStructType struct_type_CalculatorRequestType = TypeObjectUtils::build_complete_struct_type(struct_flags_CalculatorRequestType, header_CalculatorRequestType, member_seq_CalculatorRequestType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_CalculatorRequestType, type_name_CalculatorRequestType.to_string(), type_ids_CalculatorRequestType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "CalculatorRequestType already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_CalculatorReplyType_type_identifier(
        TypeIdentifierPair& type_ids_CalculatorReplyType)
{

    ReturnCode_t return_code_CalculatorReplyType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_CalculatorReplyType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "CalculatorReplyType", type_ids_CalculatorReplyType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_CalculatorReplyType)
    {
        StructTypeFlag struct_flags_CalculatorReplyType = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_CalculatorReplyType = "CalculatorReplyType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_CalculatorReplyType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_CalculatorReplyType;
        AppliedAnnotationSeq tmp_ann_custom_CalculatorReplyType;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_CalculatorReplyType;
        if (!tmp_ann_custom_CalculatorReplyType.empty())
        {
            ann_custom_CalculatorReplyType = tmp_ann_custom_CalculatorReplyType;
        }

        CompleteTypeDetail detail_CalculatorReplyType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_CalculatorReplyType, ann_custom_CalculatorReplyType, type_name_CalculatorReplyType.to_string());
        CompleteStructHeader header_CalculatorReplyType;
        header_CalculatorReplyType = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_CalculatorReplyType);
        CompleteStructMemberSeq member_seq_CalculatorReplyType;
        {
            TypeIdentifierPair type_ids_client_id;
            ReturnCode_t return_code_client_id {eprosima::fastdds::dds::RETCODE_OK};
            return_code_client_id =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_client_id);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_client_id)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_client_id))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_client_id = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_client_id = 0x00000000;
            bool common_client_id_ec {false};
            CommonStructMember common_client_id {TypeObjectUtils::build_common_struct_member(member_id_client_id, member_flags_client_id, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_client_id, common_client_id_ec))};
            if (!common_client_id_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure client_id member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_client_id = "client_id";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_client_id;
            ann_custom_CalculatorReplyType.reset();
            AppliedAnnotationSeq tmp_ann_custom_client_id;
            eprosima::fastcdr::optional<std::string> unit_client_id;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_client_id;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_client_id;
            eprosima::fastcdr::optional<std::string> hash_id_client_id;
            if (unit_client_id.has_value() || min_client_id.has_value() || max_client_id.has_value() || hash_id_client_id.has_value())
            {
                member_ann_builtin_client_id = TypeObjectUtils::build_applied_builtin_member_annotations(unit_client_id, min_client_id, max_client_id, hash_id_client_id);
            }
            if (!tmp_ann_custom_client_id.empty())
            {
                ann_custom_CalculatorReplyType = tmp_ann_custom_client_id;
            }
            CompleteMemberDetail detail_client_id = TypeObjectUtils::build_complete_member_detail(name_client_id, member_ann_builtin_client_id, ann_custom_CalculatorReplyType);
            CompleteStructMember member_client_id = TypeObjectUtils::build_complete_struct_member(common_client_id, detail_client_id);
            TypeObjectUtils::add_complete_struct_member(member_seq_CalculatorReplyType, member_client_id);
        }
        {
            TypeIdentifierPair type_ids_result;
            ReturnCode_t return_code_result {eprosima::fastdds::dds::RETCODE_OK};
            return_code_result =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_result);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_result)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "result Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_result = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_result = 0x00000001;
            bool common_result_ec {false};
            CommonStructMember common_result {TypeObjectUtils::build_common_struct_member(member_id_result, member_flags_result, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_result, common_result_ec))};
            if (!common_result_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure result member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_result = "result";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_result;
            ann_custom_CalculatorReplyType.reset();
            CompleteMemberDetail detail_result = TypeObjectUtils::build_complete_member_detail(name_result, member_ann_builtin_result, ann_custom_CalculatorReplyType);
            CompleteStructMember member_result = TypeObjectUtils::build_complete_struct_member(common_result, detail_result);
            TypeObjectUtils::add_complete_struct_member(member_seq_CalculatorReplyType, member_result);
        }
        CompleteStructType struct_type_CalculatorReplyType = TypeObjectUtils::build_complete_struct_type(struct_flags_CalculatorReplyType, header_CalculatorReplyType, member_seq_CalculatorReplyType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_CalculatorReplyType, type_name_CalculatorReplyType.to_string(), type_ids_CalculatorReplyType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "CalculatorReplyType already registered in TypeObjectRegistry for a different type.");
        }
    }
}

