"""
Inguma Penetration Testing Toolkit
Copyright (c) 2006, 2007 Joxean Koret, joxeankoret [at] yahoo.es

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""
import socket

from libtnserrors import TNS_ERROR_CODES, getTnsErrorMessage

versionPacket  = "\x00\x5a\x00\x00\x01\x00\x00\x00"
versionPacket += "\x01\x36\x01\x2c\x00\x00\x08\x00"
versionPacket += "\x7f\xff\x7f\x08\x00\x00\x00\x01"
versionPacket += "\x00\x20\x00\x3a\x00\x00\x00\x00"
versionPacket += "\x00\x00\x00\x00\x00\x00\x00\x00"
versionPacket += "\x00\x00\x00\x00\x34\xe6\x00\x00"
versionPacket += "\x00\x01\x00\x00\x00\x00\x00\x00"
versionPacket += "\x00\x00"
versionPacket += "(CONNECT_DATA=(COMMAND=version))"

class TNSPacket:

    version = 10

    # :1 is the size + 58 of the packet
    basePacket  = "\x00:1\x00\x00\x01\x00\x00\x00"
    basePacket += "\x01\x36\x01\x2c\x00\x00\x08\x00"
    basePacket += "\x7f\xff\x7f\x08\x00\x00\x00\x01"
    # :2 is the real size of the packet
    basePacket += "\x00:2\x00\x3a\x00\x00\x00\x00"
    basePacket += "\x00\x00\x00\x00\x00\x00\x00\x00"
    basePacket += "\x00\x00\x00\x00\x34\xe6\x00\x00"
    basePacket += "\x00\x01\x00\x00\x00\x00\x00\x00"
    basePacket += "\x00\x00"

    # :1 is the size + 58 of the packet
    base10gPacket  = "\x00:1\x00\x00\x01\x00\x00\x00"
    base10gPacket += "\x01\x39\x01\x2c\x00\x81\x08\x00"
    base10gPacket += "\x7f\xff\x7f\x08\x00\x00\x01\x00"
    # :2 is the real size of the packet
    base10gPacket += "\x00:2\x00\x3a\x00\x00\x07\xf8"
    base10gPacket += "\x0c\x0c\x00\x00\x00\x00\x00\x00"
    base10gPacket += "\x00\x00\x00\x00\x00\x00\x00\x00"
    base10gPacket += "\x00\x00\x00\x00\x00\x00\x00\x00"
    base10gPacket += "\x00\x00"

    def getPacket(self, cmd):
        hLen1 = len(cmd) + 58
        hLen2 = len(cmd)

        x1 = str(hex(hLen1)).replace("0x", "")
        x2 = str(hex(hLen2)).replace("0x", "")
        
        if len(x1) == 1:
            x1 = "0" + x1
        
        if len(x2) == 1:
            x2 = "0" + x2

        hLen1 = eval("'\\x" + x1 + "'")
        hLen2 = eval("'\\x" + x2 + "'")

        if self.version >= 10:
            data = self.base10gPacket
        else:
            data = self.basePacket

        data = data.replace(":1", hLen1)
        data = data.replace(":2", hLen2)
        data += cmd

        return data

class TNS:

    TNS_TYPE_ACCEPT = 0
    TNS_TYPE_ERROR  = 1

    TNS_V7  =  7
    TNS_V8  =  8
    TNS_V9  =  9
    TNS_V10 = 10
    TNS_V11 = 11

    tns_data = None
    banner = None

    def sendCommand(self, command):
        pass

    def sendData(self, data):
        pass

    def sendConnectRequest(self, mSocket, mBuf):
        mSocket.send(mBuf)

    def recvTNSPkt(self, mSocket):
        packet = ""
        packet = mSocket.recv(1024)

        self.tns_data = packet

        if packet.find("(ERR=0)") > 0:
            self.packet_type = TNS.TNS_TYPE_ACCEPT
        else:
            self.packet_type = TNS.TNS_TYPE_ERROR

    def recvAcceptData(self, mSocket, mData):
        packet = ""
        packet = mSocket.recv(1024)

        self.banner = packet

        return(self.tns_data + self.banner)

    def assignVersion(self, data):

        if not str(data).isalnum():
            return

        v = hex(int(data))
        v = v[0:3]
        v = eval(v)

        return(v)
    
    def getTnsError(self, code):
        return getTnsErrorMessage(code)
    
    def getPropertyValue(self, data, property):
        pos    = data.find(property + "=")

        if pos == -1:
            return None

        endPos = data.find(")", pos)
        data = data[pos+len(property)+1:endPos]

        return data
    
    def extractErrorcode(self, data):
        errCode = self.getPropertyValue(data, "CODE")

        if errCode:
            if len(errCode) < 5:
                errCode = "0"*(5-len(errCode)) + errCode

            return errCode

    def getVSNNUM(self, verInfo):
        return self.getPropertyValue(verInfo, "VSNNUM")

class TNSCONNECT:

    def getVersionCommand(self):
        global versionPacket

        return versionPacket

class TNSParser:

    data = ""

    def __init__(self, data):
        if data:
            self.data = data
    
    def getValueFor(self, thekey, single = False):
        buf = []
        level = 0
        value = False
        flag = False
        word = ""

        for char in self.data:
            if char == "(":
                level += 1
                key = ""
                if value:
                    flag = True

                word = ""
            elif char == ")":
            
                if key.lower() == thekey.lower():
                    if not single:
                        buf.append(word)
                    else:
                        single = word
                        break

                level -= 1
                value = False
                word = ""
            elif char == "=":
                value = True
                key = word
                word = ""
            else:
                word += char

        return buf

class TNSDataFormatter:

    data = ""

    def __init__(self, data):
        if data:
            self.data = data
    
    def format(self):
        buf = "\r\n"
        level = 0
        value = False
        flag = False
        word = ""

        for char in self.data:
            if char == "(":
                level += 1
                if value:
                    flag = True
                    buf += "\r\n"

                buf += "  " + "  "*level
                word = ""
            elif char == ")":
                level -= 1
                value = False
                buf += "\r\n"
                word = ""
            elif char == "=":
                value = True
                buf += ": "
                word = ""
            else:
                buf += char
                word += char

        return buf
