/* See LICENSE for licensing and NOTICE for copyright. */
package org.ldaptive;

import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * Unit test for {@link ModifyDnRequest}.
 *
 * @author  Middleware Services
 */
public class ModifyDnRequestTest
{


  /**
   * Modify DN test data.
   *
   * @return  request test data
   */
  @DataProvider(name = "request")
  public Object[][] createData()
  {
    return
      new Object[][] {
        new Object[] {
          ModifyDnRequest.builder()
            .oldDN("uid=jdoe,ou=People,dc=example,dc=com")
            .newRDN("uid=john.doe")
            .delete(true).build(),
          new byte[] {
            // preamble
            0x30, 0x3c, 0x02, 0x01, 0x02,
            // modify dn op
            0x6c, 0x37,
            // old DN
            0x04, 0x24, 0x75, 0x69, 0x64, 0x3d, 0x6a, 0x64, 0x6f, 0x65, 0x2c, 0x6f, 0x75, 0x3d, 0x50, 0x65, 0x6f, 0x70,
            0x6c, 0x65, 0x2c, 0x64, 0x63, 0x3d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x64, 0x63, 0x3d, 0x63,
            0x6f, 0x6d,
            // new RDN
            0x04, 0x0c, 0x75, 0x69, 0x64, 0x3d, 0x6a, 0x6f, 0x68, 0x6e, 0x2e, 0x64, 0x6f, 0x65,
            // delete old RDN
            0x01, 0x01, (byte) 0xff},
        },
        new Object[] {
          ModifyDnRequest.builder()
            .oldDN("uid=john.doe,ou=People,dc=example,dc=com")
            .newRDN("uid=john.doe")
            .delete(false)
            .superior("ou=Users,dc=example,dc=com").build(),
          new byte[] {
            // preamble
            0x30, 0x5c, 0x02, 0x01, 0x02,
            // modify dn op
            0x6c, 0x57,
            // old DN
            0x04, 0x28, 0x75, 0x69, 0x64, 0x3d, 0x6a, 0x6f, 0x68, 0x6e, 0x2e, 0x64, 0x6f, 0x65, 0x2c, 0x6f, 0x75, 0x3d,
            0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x2c, 0x64, 0x63, 0x3d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c,
            0x64, 0x63, 0x3d, 0x63, 0x6f, 0x6d,
            // new RDN
            0x04, 0x0c, 0x75, 0x69, 0x64, 0x3d, 0x6a, 0x6f, 0x68, 0x6e, 0x2e, 0x64, 0x6f, 0x65,
            // delete old RDN
            0x01, 0x01, 0x00,
            // new superior DN
            (byte) 0x80, 0x1a, 0x6f, 0x75, 0x3d, 0x55, 0x73, 0x65, 0x72, 0x73, 0x2c, 0x64, 0x63, 0x3d, 0x65, 0x78, 0x61,
            0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x64, 0x63, 0x3d, 0x63, 0x6f, 0x6d},
        },
        new Object[] {
          ModifyDnRequest.builder()
            .oldDN("uid=jdoe,ou=People,dc=example,dc=com")
            .newRDN("uid=john.doe")
            .delete(true)
            .superior("ou=Users,dc=example,dc=com").build(),
          new byte[] {
            // preamble
            0x30, 0x58, 0x02, 0x01, 0x02,
            // modify dn op
            0x6c, 0x53,
            // old DN
            0x04, 0x24, 0x75, 0x69, 0x64, 0x3d, 0x6a, 0x64, 0x6f, 0x65, 0x2c, 0x6f, 0x75, 0x3d, 0x50, 0x65, 0x6f, 0x70,
            0x6c, 0x65, 0x2c, 0x64, 0x63, 0x3d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x64, 0x63, 0x3d, 0x63,
            0x6f, 0x6d,
            // new RDN
            0x04, 0x0c, 0x75, 0x69, 0x64, 0x3d, 0x6a, 0x6f, 0x68, 0x6e, 0x2e, 0x64, 0x6f, 0x65,
            // delete old RDN
            0x01, 0x01, (byte) 0xff,
            // new superior DN
            (byte) 0x80, 0x1a, 0x6f, 0x75, 0x3d, 0x55, 0x73, 0x65, 0x72, 0x73, 0x2c, 0x64, 0x63, 0x3d, 0x65, 0x78, 0x61,
            0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x64, 0x63, 0x3d, 0x63, 0x6f, 0x6d},
        },
      };
  }


  /**
   * @param  request  modify dn request request to encode.
   * @param  berValue  expected value.
   *
   * @throws  Exception  On test failure.
   */
  @Test(dataProvider = "request")
  public void encode(final ModifyDnRequest request, final byte[] berValue)
    throws Exception
  {
    Assert.assertEquals(request.encode(2), berValue);
  }
}
