% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualCovariate.R
\name{residualCovariate}
\alias{residualCovariate}
\title{Residual-center all target indicators by covariates}
\usage{
residualCovariate(data, targetVar, covVar)
}
\arguments{
\item{data}{The desired data to be transformed.}

\item{targetVar}{Varible names or the position of indicators that users wish
to be residual centered (as dependent variables)}

\item{covVar}{Covariate names or the position of the covariates using for
residual centering (as independent variables) onto target variables}
}
\value{
The data that the target variables replaced by the residuals
}
\description{
This function will regress target variables on the covariate and replace the
target variables by the residual of the regression analysis. This procedure
is useful to control the covariate from the analysis model (Geldhof,
Pornprasertmanit, Schoemann, & Little, 2013).
}
\examples{

dat <- residualCovariate(attitude, 2:7, 1)

}
\references{
Geldhof, G. J., Pornprasertmanit, S., Schoemann, A. M., &
Little, T. D. (2013). Orthogonalizing through residual centering:
Extended applications and caveats. \emph{Educational and Psychological
Measurement, 73}(1), 27--46. \doi{10.1177/0013164412445473}
}
\seealso{
\code{\link[=indProd]{indProd()}} For creating the indicator products with no
centering, mean centering, double-mean centering, or residual centering.
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})
}
