#!/usr/bin/perl -w

use strict;
use warnings;

use ExtUtils::MakeMaker;
use ExtUtils::Depends;

my $eud = ExtUtils::Depends->new(qw/Alien::ffmpeg/);

WriteMakefile(
	NAME	=> "SReview",
	ABSTRACT_FROM => "lib/SReview.pm",
	VERSION_FROM => "lib/SReview.pm",
	AUTHOR => [
		'Wouter Verhelst <w@uter.be>',
	],
	PREREQ_PM => {
		'Mojo::JSON' => 0,
		'Mojo::Pg' => 0,
		'Mojolicious::Plugin::OpenAPI' => 0,
		'Moose' => 0,
		'DateTime' => 0,
		'DateTime::Format::ISO8601' => 0,
		'DateTime::Format::Pg' => 0,
		'Net::Amazon::S3' => 0,
		'Net::SSH::AuthorizedKeysFile' => 0,
	},
	TEST_REQUIRES => {
		'Test::More' => 0,
	},
	CONFIGURE_REQUIRES => {
		'ExtUtils::Depends' => 0,
	},
	EXE_FILES => [
		'scripts/sreview-cut',
		'scripts/sreview-config',
		'scripts/sreview-copy',
		'scripts/sreview-detect',
		'scripts/sreview-dispatch',
		'scripts/sreview-skip',
		'scripts/sreview-user',
		'scripts/sreview-encode',
		'scripts/sreview-notify',
		'scripts/sreview-upload',
		'scripts/sreview-transcode',
		'scripts/sreview-previews',
		'scripts/sreview-inject',
		'scripts/sreview-inject-job',
		'scripts/sreview-import',
		'web/sreview-web',
	],
	META_MERGE => {
		"meta-spec" => { version => 2 },
		resources => {
			repository => {
				type => "git",
				url => "https://github.com/yoe/SReview.git",
				web => "https://github.com/yoe/SReview",
			},
			homepage => "https://yoe.github.io/SReview",
		}
	},
	$eud->get_makefile_vars
);
